/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant;

import com.atlassian.multitenant.AuthorisationProvider;
import com.atlassian.multitenant.CustomConfigHandler;
import com.atlassian.multitenant.MultiTenantComponentFactory;
import com.atlassian.multitenant.MultiTenantLifecycleController;
import com.atlassian.multitenant.MultiTenantManager;
import com.atlassian.multitenant.MultiTenantMatcher;
import com.atlassian.multitenant.SystemTenantProvider;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.TenantReference;
import com.atlassian.multitenant.impl.DefaultMultiTenantManager;
import com.atlassian.multitenant.impl.DefaultMultiTenantMatcher;
import com.atlassian.multitenant.impl.DefaultTenantReference;
import com.atlassian.multitenant.impl.MultiTenantComponentFactoryImpl;
import com.atlassian.multitenant.impl.MultiTenantDatastore;
import com.atlassian.multitenant.impl.MultiTenantParser;
import com.atlassian.multitenant.impl.NoPermissionAuthorisationProvider;
import com.atlassian.multitenant.impl.SystemTenantReference;
import com.atlassian.multitenant.impl.datastore.DelegatingSystemTenantDatastore;
import com.atlassian.multitenant.impl.datastore.EmptyDatastore;
import com.atlassian.multitenant.impl.datastore.XmlMultiTenantDatastore;
import com.atlassian.multitenant.impl.matchers.HostnameMatcher;
import com.atlassian.multitenant.impl.matchers.RequestHeaderMatcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTenantContext {
    private static final String MULTI_TENANT_PROPERTIES_FILE = "multitenant.properties";
    private static final String MULTI_TENANT_XML_FILE_NAME = "multitenant.xml";
    public static final String MULTI_TENANT_AUTHORISATION_PROVIDER_KEY = "multitenant.authorisation.provider.class";
    public static final String MULTI_TENANT_ENABLED_KEY = "multitenant.enabled";
    public static final String SYSTEM_TENANT_PROVIDER_KEY = "multitenant.system.tenant.provider";
    public static final String SINGLE_TENANT_KEY = "multitenant.single.tenant.mode";
    public static final String MULTI_TENANT_SYSTEM_HOME_PROPERTY = "multitenant.system.home";
    private static final String DEFAULT_MULTI_TENANT_SYSTEM_HOME = ".";
    private static final String HANDLER_PREFIX = "multitenant.handler.";
    private static final Logger log = Logger.getLogger(MultiTenantContext.class);
    private final TenantReference tenantReference;
    private final MultiTenantManager manager;
    private final MultiTenantLifecycleController controller;
    private final MultiTenantComponentFactory factory;
    private final MultiTenantMatcher matcher;
    private final MultiTenantParser parser;
    private final File multiTenantSystemHome;
    private final Tenant systemTenant;
    private final AuthorisationProvider authorisationProvider;
    private static volatile MultiTenantContext INSTANCE;

    private MultiTenantContext(TenantReference tenantReference, MultiTenantManager manager, MultiTenantLifecycleController controller, MultiTenantComponentFactory factory, MultiTenantMatcher matcher, MultiTenantParser parser, File multiTenantSystemHome, Tenant systemTenant, AuthorisationProvider authorisationProvider) {
        this.tenantReference = tenantReference;
        this.manager = manager;
        this.controller = controller;
        this.factory = factory;
        this.matcher = matcher;
        this.parser = parser;
        this.multiTenantSystemHome = multiTenantSystemHome;
        this.systemTenant = systemTenant;
        this.authorisationProvider = authorisationProvider;
    }

    public static void defaultInit() {
        Properties props = MultiTenantContext.loadProperties();
        if (props != null && Boolean.parseBoolean(props.getProperty(MULTI_TENANT_ENABLED_KEY, "false"))) {
            MultiTenantContext.defaultInit(props);
        }
    }

    public static synchronized void defaultInit(Properties props) {
        TenantReference tenantReference;
        MultiTenantDatastore backingDatastore;
        MultiTenantDatastore parser;
        boolean singleTenantMode;
        Map<String, CustomConfigHandler<?>> handlers = MultiTenantContext.initHandlers(props);
        File multiTenantSystemHome = null;
        Tenant systemTenant = MultiTenantContext.getSystemTenant(props);
        if (systemTenant == null) {
            multiTenantSystemHome = MultiTenantContext.locateSystemHome(props);
        }
        if (singleTenantMode = Boolean.parseBoolean(props.getProperty(SINGLE_TENANT_KEY, "true"))) {
            EmptyDatastore emptyDatastore;
            parser = emptyDatastore = new EmptyDatastore();
            backingDatastore = emptyDatastore;
            tenantReference = new SystemTenantReference();
        } else {
            File multiTenantXmlFile = systemTenant != null ? new File(systemTenant.getHomeDir(), MULTI_TENANT_XML_FILE_NAME) : new File(multiTenantSystemHome, MULTI_TENANT_XML_FILE_NAME);
            XmlMultiTenantDatastore xmlDatastore = new XmlMultiTenantDatastore(handlers, multiTenantXmlFile);
            parser = xmlDatastore;
            backingDatastore = xmlDatastore;
            tenantReference = new DefaultTenantReference();
        }
        MultiTenantDatastore datastore = systemTenant != null ? new DelegatingSystemTenantDatastore(backingDatastore, systemTenant) : backingDatastore;
        DefaultMultiTenantManager manager = new DefaultMultiTenantManager(datastore, tenantReference, singleTenantMode);
        MultiTenantComponentFactoryImpl factory = new MultiTenantComponentFactoryImpl(tenantReference, manager, datastore);
        DefaultMultiTenantMatcher matcher = new DefaultMultiTenantMatcher(Arrays.asList(new RequestHeaderMatcher(datastore), new HostnameMatcher(datastore)));
        AuthorisationProvider authorisationProvider = MultiTenantContext.initialiseAuthorisationProvider(props, singleTenantMode);
        INSTANCE = new MultiTenantContext(tenantReference, manager, manager, factory, matcher, (MultiTenantParser)((Object)parser), multiTenantSystemHome, systemTenant, authorisationProvider);
    }

    public static boolean isEnabled() {
        return INSTANCE != null;
    }

    public static File getSystemHome() {
        if (MultiTenantContext.INSTANCE.systemTenant != null) {
            return new File(MultiTenantContext.INSTANCE.systemTenant.getHomeDir());
        }
        return MultiTenantContext.INSTANCE.multiTenantSystemHome;
    }

    public static TenantReference getTenantReference() {
        return MultiTenantContext.INSTANCE.tenantReference;
    }

    public static MultiTenantManager getManager() {
        return MultiTenantContext.INSTANCE.manager;
    }

    public static MultiTenantLifecycleController getController() {
        return MultiTenantContext.INSTANCE.controller;
    }

    public static MultiTenantComponentFactory getFactory() {
        return MultiTenantContext.INSTANCE.factory;
    }

    public static MultiTenantMatcher getMatcher() {
        return MultiTenantContext.INSTANCE.matcher;
    }

    public static MultiTenantParser getParser() {
        return MultiTenantContext.INSTANCE.parser;
    }

    public static Tenant getSystemTenant() {
        return MultiTenantContext.INSTANCE.systemTenant;
    }

    public static AuthorisationProvider getAuthorisationProvider() {
        return MultiTenantContext.INSTANCE.authorisationProvider;
    }

    public static void setInstance(MultiTenantContext instance) {
        INSTANCE = instance;
    }

    public static void setTenantReference(TenantReference tenantReference) {
        INSTANCE = new Builder(INSTANCE).tenantReference(tenantReference).construct();
    }

    public static void setManager(MultiTenantManager manager) {
        INSTANCE = new Builder(INSTANCE).manager(manager).construct();
    }

    public static void setController(MultiTenantLifecycleController controller) {
        INSTANCE = new Builder(INSTANCE).controller(controller).construct();
    }

    public static void setFactory(MultiTenantComponentFactory factory) {
        INSTANCE = new Builder(INSTANCE).factory(factory).construct();
    }

    public static void setMatcher(MultiTenantMatcher matcher) {
        INSTANCE = new Builder(INSTANCE).matcher(matcher).construct();
    }

    public static void setParser(MultiTenantParser parser) {
        INSTANCE = new Builder(INSTANCE).parser(parser).construct();
    }

    public static void setSystemTenant(Tenant systemTenant) {
        INSTANCE = new Builder(INSTANCE).systemTenant(systemTenant).construct();
    }

    public static void setAuthorisationProvider(AuthorisationProvider authorisationProvider) {
        INSTANCE = new Builder(INSTANCE).authorisationProvider(authorisationProvider).construct();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties() {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(MULTI_TENANT_PROPERTIES_FILE);
        if (is != null) {
            log.info((Object)"Found multitenant.properties in context classloader");
        } else {
            is = MultiTenantContext.class.getClassLoader().getResourceAsStream(MULTI_TENANT_PROPERTIES_FILE);
        }
        if (is != null) {
            log.info((Object)"Found multitenant.properties in this classloader");
        } else {
            File file = new File(MULTI_TENANT_PROPERTIES_FILE);
            if (file.exists() && file.isFile() && file.canRead()) {
                log.info((Object)("Found multitenant.properties on filesystem at " + file.getAbsolutePath()));
                try {
                    is = new FileInputStream(file);
                }
                catch (IOException ioe) {
                    log.warn((Object)"Error loading multitenant properties file", (Throwable)ioe);
                }
            }
        }
        Properties properties = new Properties();
        if (is != null) {
            try {
                properties.load(is);
            }
            catch (IOException ioe) {
                log.warn((Object)"Error loading multitenant properties file", (Throwable)ioe);
                Properties properties2 = null;
                return properties2;
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    private static Map<String, CustomConfigHandler<?>> initHandlers(Properties props) {
        HashMap handlers = new HashMap();
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(HANDLER_PREFIX)) continue;
            String handlerName = name.substring(HANDLER_PREFIX.length());
            String className = props.getProperty(name);
            handlers.put(handlerName, MultiTenantContext.loadExtension(className, CustomConfigHandler.class));
        }
        return handlers;
    }

    private static File locateSystemHome(Properties props) {
        File homeDir;
        String homePath = props.getProperty(MULTI_TENANT_SYSTEM_HOME_PROPERTY);
        if (homePath == null) {
            log.warn((Object)("Multi tenant system home path not set, using current working directory: " + new File(DEFAULT_MULTI_TENANT_SYSTEM_HOME).getAbsolutePath()));
            homePath = DEFAULT_MULTI_TENANT_SYSTEM_HOME;
        }
        if (!(homeDir = new File(homePath)).exists()) {
            throw new IllegalArgumentException("Multitenant home directory does not exist: " + homeDir.getAbsolutePath());
        }
        if (!homeDir.isDirectory()) {
            throw new IllegalArgumentException("Multitenant home directory is not a directory: " + homeDir.getAbsolutePath());
        }
        if (!homeDir.canRead()) {
            throw new IllegalArgumentException("Multitenant home directory is not readable: " + homeDir.getAbsolutePath());
        }
        if (!homeDir.canWrite()) {
            throw new IllegalArgumentException("Multitenant home directory is not writable: " + homeDir.getAbsolutePath());
        }
        return homeDir;
    }

    private static Tenant getSystemTenant(Properties props) {
        String systemTenantProviderClassName = props.getProperty(SYSTEM_TENANT_PROVIDER_KEY);
        if (systemTenantProviderClassName != null) {
            SystemTenantProvider provider = MultiTenantContext.loadExtension(systemTenantProviderClassName, SystemTenantProvider.class);
            return provider.getSystemTenant();
        }
        return null;
    }

    private static AuthorisationProvider initialiseAuthorisationProvider(Properties props, boolean singleTenantMode) {
        String authorisationProviderClassName = props.getProperty(MULTI_TENANT_AUTHORISATION_PROVIDER_KEY);
        if (authorisationProviderClassName == null || singleTenantMode) {
            return new NoPermissionAuthorisationProvider();
        }
        return MultiTenantContext.loadExtension(authorisationProviderClassName, AuthorisationProvider.class);
    }

    private static <T> T loadExtension(String className, Class<T> interfaceClass) {
        Class<?> loadedClass = null;
        try {
            loadedClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException cfne) {
            // empty catch block
        }
        if (loadedClass == null) {
            try {
                loadedClass = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Couldn't find class for extension", cnfe);
            }
        }
        if (!interfaceClass.isAssignableFrom(loadedClass)) {
            throw new ClassCastException("Loaded extension (" + className + ") is not of type (" + interfaceClass + ")");
        }
        try {
            Class<?> castClass = loadedClass;
            return (T)castClass.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Error instantiating extension " + className, iae);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Error instantiating extension " + className, ie);
        }
    }

    public static class Builder {
        private TenantReference tenantReference;
        private MultiTenantManager manager;
        private MultiTenantLifecycleController controller;
        private MultiTenantComponentFactory factory;
        private MultiTenantMatcher matcher;
        private MultiTenantParser parser;
        private File multiTenantSystemHome;
        private Tenant systemTenant;
        private AuthorisationProvider authorisationProvider;

        public Builder() {
        }

        private Builder(MultiTenantContext context) {
            if (context != null) {
                this.tenantReference = context.tenantReference;
                this.manager = context.manager;
                this.controller = context.controller;
                this.factory = context.factory;
                this.matcher = context.matcher;
                this.parser = context.parser;
                this.multiTenantSystemHome = context.multiTenantSystemHome;
                this.systemTenant = context.systemTenant;
                this.authorisationProvider = context.authorisationProvider;
            }
        }

        public Builder tenantReference(TenantReference tenantReference) {
            this.tenantReference = tenantReference;
            return this;
        }

        public Builder manager(MultiTenantManager manager) {
            this.manager = manager;
            return this;
        }

        public Builder controller(MultiTenantLifecycleController controller) {
            this.controller = controller;
            return this;
        }

        public Builder factory(MultiTenantComponentFactory factory) {
            this.factory = factory;
            return this;
        }

        public Builder matcher(MultiTenantMatcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public Builder parser(MultiTenantParser parser) {
            this.parser = parser;
            return this;
        }

        public Builder multiTenantSystemHome(File multiTenantSystemHome) {
            this.multiTenantSystemHome = multiTenantSystemHome;
            return this;
        }

        public Builder systemTenant(Tenant systemTenant) {
            this.systemTenant = systemTenant;
            return this;
        }

        public Builder authorisationProvider(AuthorisationProvider authorisationProvider) {
            this.authorisationProvider = authorisationProvider;
            return this;
        }

        public MultiTenantContext construct() {
            return new MultiTenantContext(this.tenantReference, this.manager, this.controller, this.factory, this.matcher, this.parser, this.multiTenantSystemHome, this.systemTenant, this.authorisationProvider);
        }
    }
}

