package com.atlassian.multitenant.impl;

import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.Tenant;

/**
 * A tenant that contains a map of components
 */
public interface TenantComponentMap extends Tenant
{
    /**
     * Put the given object
     *
     * @param key The component map this object belongs to
     * @param value The value
     */
    <T> void putObject(MultiTenantComponentMap<T> key, T value);

    /**
     * Whether this tenant has an object for this map
     *
     * @param key The map to check for
     * @return True if it does
     */
    <T> boolean hasObject(final MultiTenantComponentMap<T> key);

    /**
     * Get the object for this map
     *
     * @param key The component map to get the object for
     * @return The object, if one exists, otherwise null
     */
    <T> T getObject(MultiTenantComponentMap<T> key);

    /**
     * Remove the object for this map
     *
     * @param key The component map to remove this object from
     * @return The removed object
     */
    <T> T removeObject(MultiTenantComponentMap<T> key);
}
