package com.atlassian.multitenant.impl;

import com.atlassian.multitenant.Tenant;

import java.io.IOException;
import java.io.Reader;

/**
 * Parser for parsing tenants from XML
 */
public interface MultiTenantParser
{
    /**
     * Parse a tenant from the given reader
     *
     * @param reader The reader to parse the tenant from
     * @return The parsed tenant
     * @throws IOException If an error occured reading from the reader
     */
    Tenant parseTenant(Reader reader) throws IOException;
}
