package com.atlassian.multitenant;

/**
 * The tenant reference.  This delegates to a thread local to get the current tenant for the current thread.
 */
public interface TenantReference
{
    /**
     * Get the tenant for the current thread
     *
     * @return The tenant for the current thread
     * @throws IllegalStateException If no tenant is set
     */
    Tenant get() throws IllegalStateException;

    /**
     * Is a tenant set for the current thread?
     *
     * @return True if a tenant is set
     */
    boolean isSet();

    /**
     * Set the current for the current thread
     *
     * @param tenant The tenant to set
     * @param allowOverride True if this call is allowed to override an existing tenant set for the current thread.  If
     *      there is an existing tenant. it will be restored when remove() is called.
     * @throws IllegalStateException If a tenant is already set and allowOverride is not true
     */
    void set(Tenant tenant, boolean allowOverride) throws IllegalStateException;

    /**
     * Remove the tenant for the current thread
     *
     * @throws IllegalStateException If no tenant was set
     */
    void remove() throws IllegalStateException;
}
