/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.impl.matchers;

import com.atlassian.multitenant.MultiTenantMatcher;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.impl.MultiTenantDatastore;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestParameterMatcher
implements MultiTenantMatcher {
    static final String PARAMETER_NAME = "atlassianMultiTenant";
    private final MultiTenantDatastore datastore;

    public RequestParameterMatcher(MultiTenantDatastore datastore) {
        this.datastore = datastore;
    }

    public Tenant getTenantForRequest(HttpServletRequest request, HttpServletResponse response) {
        Tenant tenant;
        String value = request.getParameter(PARAMETER_NAME);
        if (value != null && (tenant = this.datastore.get(value)) != null) {
            Cookie cookie = new Cookie("atlassian.multitenant", value);
            cookie.setPath(request.getContextPath());
            response.addCookie(cookie);
            return tenant;
        }
        return null;
    }
}

