/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.impl;

import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.impl.TenantComponentMap;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTenant
implements TenantComponentMap {
    private final String name;
    private final Collection<String> hostnames;
    private final String homeDir;
    private final Map<Class<?>, Object> customConfig;
    private final Map<MultiTenantComponentMap, Object> objectMap = CopyOnWriteMap.newHashMap();

    public DefaultTenant(String name, Collection<String> hostnames, String homeDir, Map<Class<?>, Object> customConfig) {
        this.name = name;
        this.hostnames = hostnames;
        this.homeDir = homeDir;
        this.customConfig = customConfig;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<String> getHostnames() {
        return this.hostnames;
    }

    @Override
    public String getHomeDir() {
        return this.homeDir;
    }

    @Override
    public <B> B getConfig(Class<B> beanClazz) {
        return (B)this.customConfig.get(beanClazz);
    }

    @Override
    public <T> void putObject(MultiTenantComponentMap<T> key, T value) {
        this.objectMap.put(key, value);
    }

    public boolean hasObject(MultiTenantComponentMap key) {
        return this.objectMap.containsKey(key);
    }

    @Override
    public <T> T getObject(MultiTenantComponentMap<T> key) {
        return (T)this.objectMap.get(key);
    }

    @Override
    public <T> T removeObject(MultiTenantComponentMap<T> key) {
        return (T)this.objectMap.remove(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTenant that = (DefaultTenant)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

