package com.atlassian.multitenant.impl;

import com.atlassian.multitenant.CustomConfigHandler;
import org.dom4j.Element;

/**
 * Parser for setup info
 */
public class SetupInfoMultiTenantConfigHandler implements CustomConfigHandler<SetupInfoMultiTenantConfig>
{

    public Class<SetupInfoMultiTenantConfig> getBeanClass()
    {
        return SetupInfoMultiTenantConfig.class;
    }

    public SetupInfoMultiTenantConfig parse(final Element element)
    {
        String title = element.elementText("title");
        boolean publicInstance = Boolean.parseBoolean(element.elementText("public"));
        String baseUrl = element.elementText("baseurl");
        String license = element.elementText("license");
        Element user = element.element("admin-user");
        String username = user.elementText("username");
        String password = user.elementText("password");
        String email = user.elementText("email");
        String fullName = user.elementText("fullname");
        SetupUserMultiTenantConfig userConfig = new SetupUserMultiTenantConfig(username, password, email, fullName);
        return new SetupInfoMultiTenantConfig(title, publicInstance, baseUrl, license, userConfig);
    }

    public void writeTo(final Element element, final SetupInfoMultiTenantConfig bean)
    {
        element.addElement("title").setText(bean.getTitle());
        element.addElement("public").setText(Boolean.toString(bean.isPublicInstance()));
        element.addElement("baseurl").setText(bean.getBaseUrl());
        element.addElement("license").setText(bean.getLicense());
        Element user = element.addElement("admin-user");
        user.addElement("username").setText(bean.getUser().getUsername());
        user.addElement("password").setText(bean.getUser().getPassword());
        user.addElement("email").setText(bean.getUser().getEmail());
        user.addElement("fullname").setText(bean.getUser().getFullName());
    }
}
