package com.atlassian.multitenant;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Match a tenant to a given request
 */
public interface MultiTenantMatcher
{
    /**
     * Get the tenant for the given request
     *
     * @param request The request
     * @param response The response
     * @return The tenant, or null if this matcher didn't match any tenants to the request
     */
    Tenant getTenantForRequest(HttpServletRequest request, HttpServletResponse response);
}
