package com.atlassian.multitenant;

/**
 * Builder for the {@link MultiTenantComponentMap}
 */
public interface MultiTenantComponentMapBuilder<T>
{
    /**
     * Set the destroyer to use for this map.  If the creator is also a destroyer, this method does not need to be
     * called.
     *
     * @param destroyer The destroyer to set
     * @return This builder
     */
    MultiTenantComponentMapBuilder<T> setDestroyer(MultiTenantDestroyer<T> destroyer);

    /**
     * Set the lazy load strategy for the map.  The default strategy is LAZY_LOAD.
     *
     * @param lazyLoadStrategy The strategy to set
     * @return This builder
     */
    MultiTenantComponentMapBuilder<T> setLazyLoad(MultiTenantComponentMap.LazyLoadStrategy lazyLoadStrategy);

    /**
     * Set the no tenant strategy for the map.  The default is FAIL.
     *
     * @param strategy The strategy to set
     * @return This builder
     */
    MultiTenantComponentMapBuilder<T> setNoTenantStrategy(MultiTenantComponentMap.NoTenantStrategy strategy);

    /**
     * Whether to register this component's lifecycle listener with the MultiTenantManager. The default is YES.
     * @see com.atlassian.multitenant.MultiTenantComponentMap.Registration#YES
     * @param choice to use for handling the registration of the lifecycle of the component
     * @return this builder
     */
    MultiTenantComponentMapBuilder<T> registerListener(MultiTenantComponentMap.Registration choice);

    /**
     * Construct the map.  Calling this will render this builder useless, subsequent calls to any methods will result
     * in NullPointerExceptions.
     *
     * @return The newly constructed map.
     */
    MultiTenantComponentMap<T> construct();
}
