package com.atlassian.multitenant;

import org.dom4j.Document;
import org.dom4j.Element;

/**
 * Handler for custom config. This handles the parsing and writing of custom config to and from an XML document.
 */
public interface CustomConfigHandler<B>
{
    /**
     * Get the bean class that this handler returns/handles
     *
     * @return The bean class this handler handles
     */
    Class<B> getBeanClass();

    /**
     * Parse the given element into a bean
     *
     * @param element The element to parse
     * @return The bean
     */
    B parse(Element element);

    /**
     * Write the given bean to the given element
     *
     * @param element The element to write to
     * @param bean The bean to write
     */
    void writeTo(Element element, B bean);
}
