/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.servlet;

import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.TenantReference;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;

public class MultiTenantSessionListener
implements HttpSessionListener {
    private static final Logger log = Logger.getLogger(MultiTenantSessionListener.class);

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        TenantReference tenantReference = MultiTenantContext.getTenantReference();
        if (!tenantReference.isSet()) {
            log.warn((Object)"Session created without a tenant being set");
        } else {
            Tenant tenant = tenantReference.get();
            httpSessionEvent.getSession().setAttribute("multitenant.tenant", (Object)tenant.getName());
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
    }
}

