/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.servlet;

import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.Tenant;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class MultiTenantServletFilter
implements Filter {
    private static final Logger log = Logger.getLogger(MultiTenantServletFilter.class);
    public static final String TENANT_SESSION_KEY = "multitenant.tenant";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public static String getTenantName(HttpSession session) throws IllegalStateException {
        Object attribute = session.getAttribute(TENANT_SESSION_KEY);
        if (attribute == null) {
            throw new IllegalStateException("No tenant found in session.");
        }
        return (String)attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            Tenant tenant = MultiTenantContext.getManager().isSingleTenantMode() ? MultiTenantContext.getSystemTenant() : MultiTenantContext.getMatcher().getTenantForRequest(httpRequest, (HttpServletResponse)response);
            if (tenant != null) {
                HttpSession session = ((HttpServletRequest)request).getSession(false);
                if (session != null) {
                    String old = (String)session.getAttribute(TENANT_SESSION_KEY);
                    if (old == null) {
                        log.warn((Object)"Session found without a tenant, is the MultiTenantSessionListener configured? If not, this instance is vulnerable to session fixation.");
                        session.setAttribute(TENANT_SESSION_KEY, (Object)tenant.getName());
                    } else if (!old.equals(tenant.getName())) {
                        session.invalidate();
                        httpResponse.sendError(403, "This session was already associated with another tenant");
                        return;
                    }
                }
                MultiTenantContext.getTenantReference().set(tenant, false);
                try {
                    filterChain.doFilter(request, response);
                }
                finally {
                    MultiTenantContext.getTenantReference().remove();
                }
                return;
            }
            httpResponse.sendError(404, "No tenant found to handle request, please check your hostname");
            return;
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }
}

