/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.servlet;

import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.Tenant;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class MultiTenantServlet
extends HttpServlet {
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.hasPermission(req, resp)) {
            super.service(req, resp);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Document document = DocumentHelper.createDocument();
        if (req.getPathInfo() != null && req.getPathInfo().length() > 0) {
            String tenantName = req.getPathInfo().substring(1);
            Tenant tenant = MultiTenantContext.getManager().getTenantByName(tenantName);
            if (tenant == null) {
                resp.sendError(404, "Tenant not found");
                return;
            }
            Element tenantElement = document.addElement("tenant");
            this.populateTenant(tenantElement, tenant);
        } else {
            Element rootElement = document.addElement("multitenant");
            for (Tenant tenant : MultiTenantContext.getManager().getAllTenants()) {
                Element tenantElement = rootElement.addElement("tenant");
                this.populateTenant(tenantElement, tenant);
            }
        }
        resp.setContentType("application/xml");
        XMLWriter xmlWriter = new XMLWriter((Writer)resp.getWriter(), OutputFormat.createPrettyPrint());
        xmlWriter.write(document);
    }

    private void populateTenant(Element tenantElement, Tenant tenant) {
        tenantElement.addAttribute("name", tenant.getName());
        Element hostnamesElement = tenantElement.addElement("hostnames");
        for (String hostname : tenant.getHostnames()) {
            Element hostnameElement = hostnamesElement.addElement("hostname");
            hostnameElement.setText(hostname);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!req.getContentType().startsWith("application/xml")) {
            resp.sendError(403, "Only application/xml allowed");
            return;
        }
        Tenant tenant = MultiTenantContext.getParser().parseTenant(req.getReader());
        MultiTenantContext.getController().addTenant(tenant);
        resp.setStatus(204);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String name = req.getPathInfo();
        if (name != null && name.length() > 1) {
            name = name.substring(1);
            MultiTenantContext.getController().removeTenant(name);
            resp.setStatus(204);
        } else {
            resp.sendError(404, "A resource to delete was not specified");
        }
    }

    private boolean hasPermission(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (MultiTenantContext.getSystemTenant() != MultiTenantContext.getTenantReference().get()) {
            response.sendError(403, "Not system tenant");
            return false;
        }
        if (!MultiTenantContext.getAuthorisationProvider().canManageTenants(request)) {
            response.sendError(403, "Not authorised");
            return false;
        }
        return true;
    }
}

