/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.impl.matchers;

import com.atlassian.multitenant.MultiTenantMatcher;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.impl.MultiTenantDatastore;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieMatcher
implements MultiTenantMatcher {
    static final String COOKIE_NAME = "atlassian.multitenant";
    private final MultiTenantDatastore datastore;

    public CookieMatcher(MultiTenantDatastore datastore) {
        this.datastore = datastore;
    }

    public Tenant getTenantForRequest(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equals(COOKIE_NAME)) continue;
                return this.datastore.get(cookie.getValue());
            }
        }
        return null;
    }
}

