/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.impl;

import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.TenantReference;
import java.util.LinkedList;

public class DefaultTenantReference
implements TenantReference {
    private final ThreadLocal<LinkedList<Tenant>> CONTEXT = new ThreadLocal<LinkedList<Tenant>>(){

        @Override
        protected LinkedList<Tenant> initialValue() {
            return new LinkedList<Tenant>();
        }
    };

    public Tenant get() throws IllegalStateException {
        LinkedList<Tenant> context = this.CONTEXT.get();
        if (context.isEmpty()) {
            throw new IllegalStateException("Attempt to retrieve multi tenant context when no context is set");
        }
        return context.getFirst();
    }

    public boolean isSet() {
        LinkedList<Tenant> context = this.CONTEXT.get();
        return !context.isEmpty();
    }

    public void set(Tenant tenant, boolean allowOverride) throws IllegalStateException {
        LinkedList<Tenant> context = this.CONTEXT.get();
        if (!allowOverride && !this.CONTEXT.get().isEmpty()) {
            context.removeFirst();
            throw new IllegalStateException("Attempt to set multi tenant context when one already exists");
        }
        context.addFirst(tenant);
    }

    public void remove() throws IllegalStateException {
        LinkedList<Tenant> context = this.CONTEXT.get();
        if (context.isEmpty()) {
            throw new IllegalStateException("Attempt to remove multi tenant context when none was set");
        }
        context.removeFirst();
    }
}

