/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant;

import com.atlassian.multitenant.AuthorisationProvider;
import com.atlassian.multitenant.CustomConfigHandler;
import com.atlassian.multitenant.MultiTenantComponentFactory;
import com.atlassian.multitenant.MultiTenantLifecycleController;
import com.atlassian.multitenant.MultiTenantManager;
import com.atlassian.multitenant.MultiTenantMatcher;
import com.atlassian.multitenant.SystemTenantProvider;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.TenantReference;
import com.atlassian.multitenant.impl.DefaultMultiTenantManager;
import com.atlassian.multitenant.impl.DefaultMultiTenantMatcher;
import com.atlassian.multitenant.impl.DefaultTenantReference;
import com.atlassian.multitenant.impl.MultiTenantComponentFactoryImpl;
import com.atlassian.multitenant.impl.MultiTenantDatastore;
import com.atlassian.multitenant.impl.MultiTenantParser;
import com.atlassian.multitenant.impl.NoPermissionAuthorisationProvider;
import com.atlassian.multitenant.impl.SystemTenantReference;
import com.atlassian.multitenant.impl.datastore.DelegatingSystemTenantDatastore;
import com.atlassian.multitenant.impl.datastore.EmptyDatastore;
import com.atlassian.multitenant.impl.datastore.XmlMultiTenantDatastore;
import com.atlassian.multitenant.impl.matchers.HostnameMatcher;
import com.atlassian.multitenant.impl.matchers.RequestHeaderMatcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTenantContext {
    private static final String MULTI_TENANT_PROPERTIES_FILE = "multitenant.properties";
    private static final String MULTI_TENANT_XML_FILE_NAME = "multitenant.xml";
    private static final String MULTI_TENANT_AUTHORISATION_PROVIDER_KEY = "multitenant.authorisation.provider.class";
    public static final String MULTI_TENANT_ENABLED_KEY = "multitenant.enabled";
    public static final String SYSTEM_TENANT_PROVIDER_KEY = "multitenant.system.tenant.provider";
    public static final String SINGLE_TENANT_KEY = "multitenant.single.tenant.mode";
    public static final String MULTI_TENANT_SYSTEM_HOME_PROPERTY = "multitenant.system.home";
    private static final String DEFAULT_MULTI_TENANT_SYSTEM_HOME = ".";
    private static final String HANDLER_PREFIX = "multitenant.handler.";
    private static final Logger log = Logger.getLogger(MultiTenantContext.class);
    private static TenantReference tenantReference;
    private static MultiTenantManager manager;
    private static MultiTenantLifecycleController controller;
    private static MultiTenantComponentFactory factory;
    private static MultiTenantMatcher matcher;
    private static MultiTenantParser parser;
    private static File multiTenantSystemHome;
    private static Tenant systemTenant;
    private static AuthorisationProvider authorisationProvider;

    public static void defaultInit() {
        Properties props = MultiTenantContext.loadProperties();
        if (props != null) {
            MultiTenantContext.defaultInit(props);
        }
    }

    public static void defaultInit(Properties props) {
        if (Boolean.parseBoolean(props.getProperty(MULTI_TENANT_ENABLED_KEY, "false"))) {
            MultiTenantDatastore backingDatastore;
            Map<String, CustomConfigHandler<?>> handlers = MultiTenantContext.initHandlers(props);
            systemTenant = MultiTenantContext.getSystemTenant(props);
            multiTenantSystemHome = systemTenant != null ? new File(systemTenant.getHomeDir()) : MultiTenantContext.locateSystemHome(props);
            boolean singleTenantMode = Boolean.parseBoolean(props.getProperty(SINGLE_TENANT_KEY, "true"));
            if (singleTenantMode) {
                EmptyDatastore emptyDatastore = new EmptyDatastore();
                parser = emptyDatastore;
                backingDatastore = emptyDatastore;
                tenantReference = new SystemTenantReference();
            } else {
                File multiTenantXmlFile = new File(multiTenantSystemHome, MULTI_TENANT_XML_FILE_NAME);
                XmlMultiTenantDatastore xmlDatastore = new XmlMultiTenantDatastore(handlers, multiTenantXmlFile);
                parser = xmlDatastore;
                backingDatastore = xmlDatastore;
                tenantReference = new DefaultTenantReference();
            }
            MultiTenantDatastore datastore = systemTenant != null ? new DelegatingSystemTenantDatastore(backingDatastore, systemTenant) : backingDatastore;
            DefaultMultiTenantManager manager = new DefaultMultiTenantManager(datastore, tenantReference, singleTenantMode);
            MultiTenantContext.manager = manager;
            controller = manager;
            factory = new MultiTenantComponentFactoryImpl(tenantReference, manager, datastore);
            matcher = new DefaultMultiTenantMatcher(Arrays.asList(new RequestHeaderMatcher(datastore), new HostnameMatcher(datastore)));
            authorisationProvider = MultiTenantContext.initialiseAuthorisationProvider(props, singleTenantMode);
        }
    }

    public static boolean isEnabled() {
        return manager != null;
    }

    public static File getSystemHome() {
        return multiTenantSystemHome;
    }

    public static TenantReference getTenantReference() {
        return tenantReference;
    }

    public static MultiTenantManager getManager() {
        return manager;
    }

    public static MultiTenantLifecycleController getController() {
        return controller;
    }

    public static MultiTenantComponentFactory getFactory() {
        return factory;
    }

    public static MultiTenantMatcher getMatcher() {
        return matcher;
    }

    public static MultiTenantParser getParser() {
        return parser;
    }

    public static void setTenantReference(TenantReference tenantReference) {
        MultiTenantContext.tenantReference = tenantReference;
    }

    public static void setManager(MultiTenantManager manager) {
        MultiTenantContext.manager = manager;
    }

    public static void setController(MultiTenantLifecycleController controller) {
        MultiTenantContext.controller = controller;
    }

    public static void setFactory(MultiTenantComponentFactory factory) {
        MultiTenantContext.factory = factory;
    }

    public static void setMatcher(MultiTenantMatcher matcher) {
        MultiTenantContext.matcher = matcher;
    }

    public static void setParser(MultiTenantParser parser) {
        MultiTenantContext.parser = parser;
    }

    public static Tenant getSystemTenant() {
        return systemTenant;
    }

    public static void setSystemTenant(Tenant systemTenant) {
        MultiTenantContext.systemTenant = systemTenant;
    }

    public static AuthorisationProvider getAuthorisationProvider() {
        return authorisationProvider;
    }

    public static void setAuthorisationProvider(AuthorisationProvider authorisationProvider) {
        MultiTenantContext.authorisationProvider = authorisationProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties() {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(MULTI_TENANT_PROPERTIES_FILE);
        if (is != null) {
            log.info((Object)"Found multitenant.properties in context classloader");
        } else {
            is = MultiTenantContext.class.getClassLoader().getResourceAsStream(MULTI_TENANT_PROPERTIES_FILE);
        }
        if (is != null) {
            log.info((Object)"Found multitenant.properties in this classloader");
        } else {
            File file = new File(MULTI_TENANT_PROPERTIES_FILE);
            if (file.exists() && file.isFile() && file.canRead()) {
                log.info((Object)("Found multitenant.properties on filesystem at " + file.getAbsolutePath()));
                try {
                    is = new FileInputStream(file);
                }
                catch (IOException ioe) {
                    log.warn((Object)"Error loading multitenant properties file", (Throwable)ioe);
                }
            }
        }
        if (is == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException ioe) {
            log.warn((Object)"Error loading multitenant properties file", (Throwable)ioe);
            Properties properties2 = null;
            return properties2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    private static Map<String, CustomConfigHandler<?>> initHandlers(Properties props) {
        HashMap handlers = new HashMap();
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(HANDLER_PREFIX)) continue;
            String handlerName = name.substring(HANDLER_PREFIX.length());
            String className = props.getProperty(name);
            handlers.put(handlerName, MultiTenantContext.loadExtension(className, CustomConfigHandler.class));
        }
        return handlers;
    }

    private static File locateSystemHome(Properties props) {
        File homeDir;
        String homePath = props.getProperty(MULTI_TENANT_SYSTEM_HOME_PROPERTY);
        if (homePath == null) {
            log.warn((Object)("Multi tenant system home path not set, using current working directory: " + new File(DEFAULT_MULTI_TENANT_SYSTEM_HOME).getAbsolutePath()));
            homePath = DEFAULT_MULTI_TENANT_SYSTEM_HOME;
        }
        if (!(homeDir = new File(homePath)).exists()) {
            throw new IllegalArgumentException("Multitenant home directory does not exist: " + homeDir.getAbsolutePath());
        }
        if (!homeDir.isDirectory()) {
            throw new IllegalArgumentException("Multitenant home directory is not a directory: " + homeDir.getAbsolutePath());
        }
        if (!homeDir.canRead()) {
            throw new IllegalArgumentException("Multitenant home directory is not readable: " + homeDir.getAbsolutePath());
        }
        if (!homeDir.canWrite()) {
            throw new IllegalArgumentException("Multitenant home directory is not writable: " + homeDir.getAbsolutePath());
        }
        return homeDir;
    }

    private static Tenant getSystemTenant(Properties props) {
        String systemTenantProviderClassName = props.getProperty(SYSTEM_TENANT_PROVIDER_KEY);
        if (systemTenantProviderClassName != null) {
            SystemTenantProvider provider = MultiTenantContext.loadExtension(systemTenantProviderClassName, SystemTenantProvider.class);
            return provider.getSystemTenant();
        }
        return null;
    }

    private static AuthorisationProvider initialiseAuthorisationProvider(Properties props, boolean singleTenantMode) {
        String authorisationProviderClassName = props.getProperty(MULTI_TENANT_AUTHORISATION_PROVIDER_KEY);
        if (authorisationProviderClassName == null || singleTenantMode) {
            return new NoPermissionAuthorisationProvider();
        }
        return MultiTenantContext.loadExtension(authorisationProviderClassName, AuthorisationProvider.class);
    }

    private static <T> T loadExtension(String className, Class<T> interfaceClass) {
        Class<?> loadedClass = null;
        try {
            loadedClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException cfne) {
            // empty catch block
        }
        if (loadedClass == null) {
            try {
                loadedClass = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Couldn't find class for extension", cnfe);
            }
        }
        if (!interfaceClass.isAssignableFrom(loadedClass)) {
            throw new ClassCastException("Loaded extension (" + className + ") is not of type (" + interfaceClass + ")");
        }
        try {
            Class<?> castClass = loadedClass;
            return (T)castClass.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Error instantiating extension " + className, iae);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Error instantiating extension " + className, ie);
        }
    }
}

