package com.atlassian.multitenant.impl.matchers;

import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.MultiTenantMatcher;
import com.atlassian.multitenant.impl.MultiTenantDatastore;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Matches a tenant based on a request parameter.  Once matched, sets a cookie so that subsequent requests don't need
 * the parameter to be associated with this tenant.
 *
 * The parameter used is atlassianMultiTenant.  This is most useful in development where virtual hosting may not be set
 * up.
 */
public class RequestParameterMatcher implements MultiTenantMatcher
{
    static final String PARAMETER_NAME = "atlassianMultiTenant";

    private final MultiTenantDatastore datastore;

    public RequestParameterMatcher(final MultiTenantDatastore datastore)
    {
        this.datastore = datastore;
    }

    public Tenant getTenantForRequest(final HttpServletRequest request, HttpServletResponse response)
    {
        String value = request.getParameter(PARAMETER_NAME);
        if (value != null)
        {
            Tenant tenant = datastore.get(value);
            if (tenant != null)
            {
                // Set a cookie so the parameter doesn't need to be used again
                Cookie cookie = new Cookie(CookieMatcher.COOKIE_NAME, value);
                cookie.setPath(request.getContextPath());
                response.addCookie(cookie);
                return tenant;
            }
        }
        return null;
    }
}