package com.atlassian.multitenant.impl.matchers;

import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.MultiTenantMatcher;
import com.atlassian.multitenant.impl.MultiTenantDatastore;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Matches tenants based on a header parameter.  This is most useful for scripting requests behind the host that
 * maps requests.
 *
 * The header parameter is X-Atlassian-Tenant.
 */
public class RequestHeaderMatcher implements MultiTenantMatcher
{
    static final String HEADER = "X-Atlassian-Tenant";

    private final MultiTenantDatastore datastore;


    public RequestHeaderMatcher(final MultiTenantDatastore datastore)
    {
        this.datastore = datastore;
    }

    public Tenant getTenantForRequest(final HttpServletRequest request, HttpServletResponse response)
    {
        String value = request.getHeader(HEADER);
        if (value != null)
        {
            return datastore.get(value);
        }
        return null;
    }
}
