package com.atlassian.multitenant.impl.matchers;

import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.MultiTenantMatcher;
import com.atlassian.multitenant.impl.MultiTenantDatastore;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Matches a request based on a cookie value.  This cookie is usually set by the {@link RequestParameterMatcher}.
 */
public class CookieMatcher implements MultiTenantMatcher
{
    static final String COOKIE_NAME = "atlassian.multitenant";

    private final MultiTenantDatastore datastore;

    public CookieMatcher(final MultiTenantDatastore datastore)
    {
        this.datastore = datastore;
    }

    public Tenant getTenantForRequest(final HttpServletRequest request, final HttpServletResponse response)
    {
        Cookie[] cookies = request.getCookies();
        if (cookies != null)
        {
            for (Cookie cookie : request.getCookies())
            {
                if (cookie.getName().equals(COOKIE_NAME))
                {
                    return datastore.get(cookie.getValue());
                }
            }
        }
        return null;
    }
}
