package com.atlassian.multitenant.impl;

/**
 * Standard info required by most products for setup
 */
public class SetupInfoMultiTenantConfig
{
    private final String title;
    private final boolean publicInstance;
    private final String baseUrl;
    private final String license;
    private final SetupUserMultiTenantConfig user;

    public SetupInfoMultiTenantConfig(final String title, final boolean publicInstance, final String baseUrl,
            final String license, final SetupUserMultiTenantConfig user)
    {
        this.title = title;
        this.publicInstance = publicInstance;
        this.baseUrl = baseUrl;
        this.license = license;
        this.user = user;
    }

    public String getTitle()
    {
        return title;
    }

    public boolean isPublicInstance()
    {
        return publicInstance;
    }

    public String getBaseUrl()
    {
        return baseUrl;
    }

    public String getLicense()
    {
        return license;
    }

    public SetupUserMultiTenantConfig getUser()
    {
        return user;
    }
}
