package com.atlassian.multitenant.impl;

import com.atlassian.multitenant.Tenant;

import java.util.Collection;

/**
 * The data store for storing and retrieving MultiTenant configuration for a given instance.
 */
public interface MultiTenantDatastore
{
    /**
     * Get the tenant with the given name
     *
     * @param name The name of the tenant to get
     * @return The tenant with that name, or null if none with that name is found
     */
    Tenant get(String name);

    /**
     * Get all tenants currently stored on this instance
     *
     * @return A collection of tenants
     */
    Collection<Tenant> getAll();

    /**
     * Get the tenant associated with the given hostname
     *
     * @param hostname The hostname
     * @return The tenant for that hostname, or null if no tenant was mapped to that hostname
     */
    Tenant getByHostname(String hostname);

    /**
     * Add the given tenant
     *
     * @param tenant The tenant to add
     */
    void addTenant(Tenant tenant);

    /**
     * Remove the given tenant
     *
     * @param tenant The tenant to remove
     */
    void removeTenant(Tenant tenant);
}
