package com.atlassian.multitenant.impl;

import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.util.concurrent.CopyOnWriteMap;

import java.util.Collection;
import java.util.Map;

/**
 * Default implementation of a tenant
 */
public class DefaultTenant implements TenantComponentMap
{
    private final String name;
    private final Collection<String> hostnames;
    private final String homeDir;
    private final Map<Class<?>, Object> customConfig;
    private final Map<MultiTenantComponentMap, Object> objectMap = CopyOnWriteMap.newHashMap();

    public DefaultTenant(final String name, final Collection<String> hostnames, final String homeDir,
            final Map<Class<?>, Object> customConfig)
    {
        this.name = name;
        this.hostnames = hostnames;
        this.homeDir = homeDir;
        this.customConfig = customConfig;
    }

    public String getName()
    {
        return name;
    }

    public Collection<String> getHostnames()
    {
        return hostnames;
    }

    public String getHomeDir()
    {
        return homeDir;
    }

    @SuppressWarnings ("unchecked")
    public <B> B getConfig(final Class<B> beanClazz)
    {
        return (B) customConfig.get(beanClazz);
    }

    public <T> void putObject(final MultiTenantComponentMap<T> key, final T value)
    {
        objectMap.put(key, value);
    }

    public boolean hasObject(final MultiTenantComponentMap key)
    {
        return objectMap.containsKey(key);
    }

    public <T> T getObject(final MultiTenantComponentMap<T> key)
    {
        return (T) objectMap.get(key);
    }

    public <T> T removeObject(final MultiTenantComponentMap<T> key)
    {
        return (T) objectMap.remove(key);
    }

    @Override
    public boolean equals(final Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final DefaultTenant that = (DefaultTenant) o;

        if (name != null ? !name.equals(that.name) : that.name != null)
        {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode()
    {
        return name != null ? name.hashCode() : 0;
    }
}
