package com.atlassian.multitenant;

import java.util.Collection;

/**
 * A tenant
 */
public interface Tenant
{
    /**
     * Get the name of the tenant
     *
     * @return The name of the tenant
     */
    String getName();

    /**
     * Get the hostnames the tenant is mapped to
     *
     * @return The hostnames
     */
    Collection<String> getHostnames();

    /**
     * Get the home directory for the tenant
     *
     * @return The home directory for the tenant
     */
    String getHomeDir();

    /**
     * Get a custom config bean for the tenant
     *
     * @param beanClazz The class of the bean
     * @return The bean for that class, or null if none was found
     */
    <B> B getConfig(Class<B> beanClazz);
}
