package com.atlassian.multitenant;

import javax.servlet.http.HttpServletRequest;

/**
 * Provides authorisation for managing tenants.  The MultiTenant library will have already checked if the current tenant
 * is the system tenant before calling this, so implementors can assume that the current context is the system tenant.
 */
public interface AuthorisationProvider
{
    /**
     * Can this request be used to manage tenants?
     *
     * @param request The request to check
     * @return True if tenant management can be done, false otherwise
     */
    boolean canManageTenants(HttpServletRequest request);
}
