/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.modzdetector;

import com.atlassian.modzdetector.CannotCheckResource;
import com.atlassian.modzdetector.HashAlgorithm;
import com.atlassian.modzdetector.IOUtils;
import com.atlassian.modzdetector.MD5HashAlgorithm;
import com.atlassian.modzdetector.Modifications;
import com.atlassian.modzdetector.ModzRegistryException;
import com.atlassian.modzdetector.ResourceAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ModzDetector {
    private static final Logger log = Logger.getLogger(ModzDetector.class);
    private ResourceAccessor resourceAccessor;
    private HashAlgorithm hashAlgorithm;

    public ModzDetector(ResourceAccessor resourceAccessor) {
        this(resourceAccessor, new MD5HashAlgorithm());
    }

    public ModzDetector(ResourceAccessor resourceAccessor, HashAlgorithm hashAlgorithm) {
        this.resourceAccessor = resourceAccessor;
        this.hashAlgorithm = hashAlgorithm;
    }

    public Modifications getModifiedFiles() throws ModzRegistryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registry URL: " + this.resourceAccessor.getClassLoader().getResource("hash-registry.properties").toExternalForm()));
        }
        InputStream registryStream = this.loadResourceStream("hash-registry.properties");
        return this.getModifiedFiles(registryStream);
    }

    Modifications getModifiedFiles(InputStream registryStream) throws ModzRegistryException {
        if (registryStream == null) {
            throw new ModzRegistryException("No registry provided.");
        }
        try {
            Properties registry = new Properties();
            registry.load(registryStream);
            Modifications mods = new Modifications();
            long start = System.currentTimeMillis();
            this.checkRegistry(mods, registry);
            log.info((Object)("Time taken (ms) to check registry: " + (System.currentTimeMillis() - start)));
            Modifications modifications = mods;
            return modifications;
        }
        catch (IOException e) {
            throw new ModzRegistryException("Unable to load distribution files hash registry: ", e);
        }
        finally {
            IOUtils.closeQuietly(registryStream);
        }
    }

    void checkRegistry(Modifications mods, Properties registry) {
        int failureCount = 0;
        for (Map.Entry<Object, Object> prop : registry.entrySet()) {
            String propertyKey = (String)prop.getKey();
            try {
                ResourceType checkResult = this.checkResource(propertyKey, (String)prop.getValue());
                checkResult.handle(mods);
            }
            catch (CannotCheckResource cannotCheckResource) {
                ++failureCount;
            }
        }
        if (failureCount > 0) {
            log.warn((Object)("Failed to check " + failureCount + " files."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceType checkResource(String resourceName, String hash, InputStream resource) throws CannotCheckResource {
        try {
            if (resourceName == null) {
                throw new IllegalArgumentException("resourceName cannot be null");
            }
            if (hash == null) {
                throw new CannotCheckResource("Expected hash is null");
            }
            if (resource == null) {
                ResourceType resourceType = ResourceType.createRemoved(resourceName);
                return resourceType;
            }
            String actualHash = this.hashAlgorithm.getHash(resource);
            if (hash.equals(actualHash)) {
                ResourceType resourceType = ResourceType.createUnchanged(resourceName);
                return resourceType;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("detected modified resource '" + resourceName + "' expected hash " + hash + " got " + actualHash));
            }
            ResourceType resourceType = ResourceType.createModified(resourceName);
            return resourceType;
        }
        finally {
            IOUtils.closeQuietly(resource);
        }
    }

    ResourceType checkResource(String propertyKey, String hash) throws CannotCheckResource {
        InputStream resource = null;
        String prefix = propertyKey.substring(0, "cp.".length());
        String resourceName = propertyKey.substring(prefix.length(), propertyKey.length());
        if ("cp.".equals(prefix)) {
            resource = this.loadResourceStream(resourceName);
        } else if ("fs.".equals(prefix)) {
            resource = this.loadPathStream(resourceName);
        } else {
            throw new CannotCheckResource("unable to interpret registered file with key: " + propertyKey);
        }
        return this.checkResource(resourceName, hash, resource);
    }

    InputStream loadResourceStream(String resourceName) {
        return this.resourceAccessor.getClassLoader().getResourceAsStream(resourceName);
    }

    InputStream loadPathStream(String realPath) {
        return this.resourceAccessor.getResourceByPath(realPath);
    }

    static abstract class ResourceType {
        private String resourceName;

        protected ResourceType(String resourceName) {
            this.resourceName = resourceName;
        }

        static ResourceType createModified(final String resourceName) {
            return new ResourceType(resourceName){

                void handle(Modifications mods) {
                    mods.modifiedFiles.add(resourceName);
                }
            };
        }

        static ResourceType createRemoved(final String resourceName) {
            return new ResourceType(resourceName){

                void handle(Modifications mods) {
                    mods.removedFiles.add(resourceName);
                }
            };
        }

        static ResourceType createUnchanged(String resourceName) {
            return new ResourceType(resourceName){

                void handle(Modifications mods) {
                }
            };
        }

        abstract void handle(Modifications var1);
    }
}

