/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.modzdetector;

import com.atlassian.modzdetector.HashAlgorithm;
import com.atlassian.modzdetector.IOUtils;
import com.atlassian.modzdetector.MD5HashAlgorithm;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class HashRegistry {
    private static final Logger log = Logger.getLogger(HashRegistry.class);
    static final String FILE_NAME_HASH_REGISTRY_PROPERTIES = "hash-registry.properties";
    static final String PREFIX_CLASSPATH = "cp.";
    static final String PREFIX_FILESYSTEM = "fs.";
    private Properties properties;
    private HashAlgorithm algorithm;
    private String registryFilename;
    private String currentPrefix;

    public HashRegistry() {
        this(new MD5HashAlgorithm(), FILE_NAME_HASH_REGISTRY_PROPERTIES);
    }

    public HashRegistry(String fileName) {
        this(new MD5HashAlgorithm(), fileName);
    }

    public HashRegistry(HashAlgorithm algorithm, String fileName) {
        this.algorithm = algorithm;
        this.registryFilename = fileName;
        this.properties = new Properties();
        this.setFilesystemMode();
    }

    public void setClasspathMode() {
        this.currentPrefix = PREFIX_CLASSPATH;
    }

    public void setFilesystemMode() {
        this.currentPrefix = PREFIX_FILESYSTEM;
    }

    public void register(String name, InputStream contents) {
        this.properties.put(this.currentPrefix + name, this.algorithm.getHash(contents));
        IOUtils.closeQuietly(contents);
    }

    public File store() throws IOException {
        File registryFile = new File(this.registryFilename);
        FileOutputStream propertiesOut = new FileOutputStream(registryFile);
        this.properties.store(propertiesOut, " THIS FILE IS GENERATED - DO NOT MODIFY. algorithm: " + this.algorithm);
        propertiesOut.close();
        log.info((Object)("wrote " + this.properties.keySet().size() + " hashes to " + registryFile.getAbsolutePath()));
        return registryFile;
    }
}

