/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.modzdetector;

import com.atlassian.modzdetector.StreamMapper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FilesystemStreamMapper
implements StreamMapper {
    private static final char REGISTRY_SEPARATOR_CHAR = '/';
    private final File base;
    private final int basePathLength;
    private FileFilter filter;

    public FilesystemStreamMapper(File base, FileFilter filter) {
        if (!base.isDirectory() && base.canRead()) {
            throw new IllegalArgumentException("base must be a readable directory");
        }
        this.base = base;
        this.basePathLength = (base.getAbsolutePath() + "/").length();
        this.filter = filter;
    }

    public InputStream mapStream(String prefix, String resourceName) {
        if ("fs.".equals(prefix)) {
            try {
                File file = new File(this.base, resourceName);
                if (this.filter.accept(file)) {
                    return new FileInputStream(file);
                }
                throw new IllegalStateException("Non matching file cannot be mapped");
            }
            catch (FileNotFoundException ignore) {
                return null;
            }
        }
        throw new IllegalStateException("Only filesystems supported.");
    }

    public String getResourcePath(String resourceKey) {
        if (resourceKey.startsWith("fs.")) {
            String unixPath = resourceKey.substring("fs.".length());
            return unixPath.replace('/', File.separatorChar);
        }
        throw new IllegalArgumentException("only filesystem resources are supported: " + resourceKey);
    }

    public String getResourceKey(File file) {
        return "fs." + file.getAbsolutePath().substring(this.basePathLength);
    }
}

