/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.store.ConfluenceSpaceTaskStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ConfluenceSpaceTaskStoreImpl
implements ConfluenceSpaceTaskStore {
    private final EntityManagerTemplate tmpl;

    @Inject
    ConfluenceSpaceTaskStoreImpl(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public Map<String, Progress> getLatestSpaceProgress(String cloudId, Collection<String> spaceKeys) {
        String selectLatestTask = "select max(t.plan.createdTime) from ConfluenceSpaceTask t where t.spaceKey = task.spaceKey and t.progress.status != :stopped";
        return this.tmpl.query(ConfluenceSpaceTask.class, "select task from ConfluenceSpaceTask task where task.spaceKey in :spaceKeys and task.plan.cloudSite.id = :cloudId and task.plan.createdTime = (" + selectLatestTask + ")").param("cloudId", (Object)cloudId).param("spaceKeys", spaceKeys).param("stopped", (Object)ExecutionStatus.STOPPED).stream().collect(Collectors.toMap(ConfluenceSpaceTask::getSpaceKey, Task::getProgress));
    }
}

