/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.media.MediaFileUploader;
import com.atlassian.migration.agent.media.MediaFileUploaderFactory;
import com.atlassian.migration.agent.queue.QueueConsumer;
import com.atlassian.migration.agent.queue.QueueConsumerConfiguration;
import com.atlassian.migration.agent.service.ExportDirManager;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepExecutionException;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.StepSchedulerService;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Singleton
@ParametersAreNonnullByDefault
public class SpaceUploadExecutor
implements QueueConsumer,
JobRunner {
    private static final String STEP_ID_PARAMS_KEY = "stepId";
    private static final String EXPORT_FILE_ID_PARAMS_KEY = "exportFileId";
    private static final StepType UPLOAD_STEP_TYPE = StepType.DATA_UPLOAD;
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceUploadExecutor.class);
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"migration-plugin:upload-executor");
    private final ProgressTracker progressTracker;
    private final MediaFileUploaderFactory mediaFileUploaderFactory;
    private final StepSchedulerService stepSchedulerService;
    private final SchedulerService schedulerService;
    private final ExportDirManager exportDirManager;
    private final CloudSiteService cloudSiteService;
    private final StepStore stepStore;
    private final PluginTransactionTemplate ptx;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;

    @Inject
    SpaceUploadExecutor(ProgressTracker progressTracker, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, MediaFileUploaderFactory mediaFileUploaderFactory, ExportDirManager exportDirManager, CloudSiteService cloudSiteService, StepStore stepStore, PluginTransactionTemplate ptx, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder) {
        this(progressTracker, stepSchedulerService, schedulerService, mediaFileUploaderFactory, exportDirManager, cloudSiteService, stepStore, ptx, Instant::now, analyticsEventService, analyticsEventBuilder);
    }

    @VisibleForTesting
    SpaceUploadExecutor(ProgressTracker progressTracker, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, MediaFileUploaderFactory mediaFileUploaderFactory, ExportDirManager exportDirManager, CloudSiteService cloudSiteService, StepStore stepStore, PluginTransactionTemplate ptx, Supplier<Instant> instantSupplier, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder) {
        this.progressTracker = progressTracker;
        this.stepSchedulerService = stepSchedulerService;
        this.schedulerService = schedulerService;
        this.cloudSiteService = cloudSiteService;
        this.mediaFileUploaderFactory = mediaFileUploaderFactory;
        this.exportDirManager = exportDirManager;
        this.stepStore = stepStore;
        this.ptx = ptx;
        this.instantSupplier = instantSupplier;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
    }

    @PostConstruct
    public void initialize() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
    }

    @Override
    public QueueConsumerConfiguration getConsumerConfiguration() {
        return QueueConsumerConfiguration.builder(UPLOAD_STEP_TYPE.name()).withConcurrencyLevel(2).build();
    }

    @Override
    public void consume(String stepId, String jobId) {
        this.stepSchedulerService.consumeStep(stepId, UPLOAD_STEP_TYPE, () -> {
            String stepConfig = this.ptx.read(() -> this.stepStore.getStep(stepId).getConfig());
            ImmutableMap jobParams = ImmutableMap.of((Object)STEP_ID_PARAMS_KEY, (Object)stepId, (Object)EXPORT_FILE_ID_PARAMS_KEY, (Object)stepConfig);
            this.stepSchedulerService.scheduleStepOnce(stepId, RUNNER_KEY, JobId.of((String)jobId), UPLOAD_STEP_TYPE, (Map<String, Serializable>)jobParams);
            return Optional.empty();
        });
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        String stepId = (String)request.getJobConfig().getParameters().get(STEP_ID_PARAMS_KEY);
        String fileId = (String)request.getJobConfig().getParameters().get(EXPORT_FILE_ID_PARAMS_KEY);
        this.stepSchedulerService.runStep(stepId, UPLOAD_STEP_TYPE, () -> this.doSpaceUpload(stepId, fileId));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    StepResult doSpaceUpload(String stepId, String fileId) {
        long startTime = this.instantSupplier.get().toEpochMilli();
        try {
            String containerToken = this.cloudSiteService.getByStepId(stepId).getContainerToken();
            MediaFileUploader uploader = this.mediaFileUploaderFactory.create(containerToken);
            String mediaFileId = this.exportDirManager.consumeExportFileSafely(fileId, exportFile -> this.uploadFileToMedia((File)exportFile, uploader, stepId, fileId));
            StepResult stepResult = StepResult.succeeded("Data upload successful", mediaFileId);
            return stepResult;
        }
        catch (StepExecutionException e) {
            StepResult stepResult = StepResult.failed("Failed to upload file with ID " + fileId, e);
            return stepResult;
        }
        finally {
            Step step = this.stepStore.getStep(stepId);
            String planId = step.getPlan().getId();
            Task task = step.getTask();
            String taskId = task.getId();
            String spaceKey = ((ConfluenceSpaceTask)task).getSpaceKey();
            this.analyticsEventService.saveAnalyticsEvent(() -> this.analyticsEventBuilder.buildStepTimerEvent(this.instantSupplier.get().toEpochMilli() - startTime, "spaceUploaded", spaceKey, planId, taskId));
        }
    }

    @VisibleForTesting
    String uploadFileToMedia(File exportFile, MediaFileUploader uploader, String stepId, String fileId) {
        String mediaFileId = uploader.upload(exportFile, this.generateUploadTracker(stepId, exportFile.length()));
        if (StringUtils.isBlank((CharSequence)mediaFileId)) {
            throw new StepExecutionException("Failed to retrieve a valid mediaFileId.");
        }
        log.debug("Done uploading exported file: {} for step: {}, media file id: {}", new Object[]{fileId, stepId, mediaFileId});
        return mediaFileId;
    }

    @VisibleForTesting
    MediaFileUploader.Tracker generateUploadTracker(String stepId, long fileSize) {
        return uploadedBytes -> {
            int percentageComplete = fileSize == 0L ? 100 : (int)(uploadedBytes * 100L / fileSize);
            this.progressTracker.progress(stepId, percentageComplete, String.format("Uploaded %s of %s", FileUtils.byteCountToDisplaySize((long)uploadedBytes), FileUtils.byteCountToDisplaySize((long)fileSize)));
        };
    }
}

