/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.status.service.systeminfo.UsageInfo;
import com.atlassian.migration.agent.model.stats.ContentSummary;
import com.atlassian.migration.agent.model.stats.InstanceStats;
import com.atlassian.migration.agent.model.stats.ServerStats;
import com.atlassian.migration.agent.model.stats.SpaceStats;
import com.atlassian.migration.agent.model.stats.UsersGroupsStats;
import com.atlassian.migration.agent.service.FailedToLoadStatsException;
import com.atlassian.migration.agent.service.NetworkStatisticsService;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.StatsStoringService;
import com.atlassian.migration.agent.service.cloud.LegalService;
import com.atlassian.migration.agent.service.impl.MigrationTimeEstimationUtils;
import com.atlassian.migration.agent.service.impl.SingleJobExecutor;
import com.atlassian.migration.agent.store.ContentStatisticsStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultStatisticsService
implements StatisticsService {
    private final SystemInformationService systemInformationService;
    private final StatsStoringService statsStoringService;
    private final ContentStatisticsStore contentStatisticsStore;
    private final PluginTransactionTemplate ptx;
    private final SingleJobExecutor<ServerStats> executor;
    private final SpaceManager spaceManager;
    private final NetworkStatisticsService networkStatisticsService;
    private final LegalService legalService;

    @Inject
    public DefaultStatisticsService(SystemInformationService systemInformationService, StatsStoringService statsStoringService, ContentStatisticsStore contentStatisticsStore, PluginTransactionTemplate ptx, SpaceManager spaceManager, NetworkStatisticsService networkStatisticsService, LegalService legalService) {
        this(systemInformationService, statsStoringService, contentStatisticsStore, ptx, new SingleJobExecutor<ServerStats>("SiteSummaryCalculator"), spaceManager, networkStatisticsService, legalService);
    }

    @VisibleForTesting
    DefaultStatisticsService(SystemInformationService systemInformationService, StatsStoringService statsStoringService, ContentStatisticsStore contentStatisticsStore, PluginTransactionTemplate ptx, SingleJobExecutor<ServerStats> singleJobExecutor, SpaceManager spaceManager, NetworkStatisticsService networkStatisticsService, LegalService legalService) {
        this.systemInformationService = systemInformationService;
        this.statsStoringService = statsStoringService;
        this.contentStatisticsStore = contentStatisticsStore;
        this.ptx = ptx;
        this.executor = singleJobExecutor;
        this.spaceManager = spaceManager;
        this.networkStatisticsService = networkStatisticsService;
        this.legalService = legalService;
    }

    private static boolean nonZeroSpaces(StatsStoringService.Stored<ServerStats> serverStatsStored) {
        return serverStatsStored.getData().getInstanceStats().getNumberOfSpaces() != 0;
    }

    private static boolean isStoredStatsStale(Instant storedTime) {
        return storedTime.isBefore(Instant.now().minus(5L, ChronoUnit.MINUTES));
    }

    @PostConstruct
    public void initialize() {
        this.executor.execute(this::calculateServerStats);
    }

    @Override
    public ServerStats loadServerStatistics() {
        ServerStats serverStats;
        Optional<StatsStoringService.Stored<ServerStats>> maybeStoredStats = this.statsStoringService.loadServerStats(() -> ((SystemInformationService)this.systemInformationService).getConfluenceInfo());
        if (maybeStoredStats.isPresent() && DefaultStatisticsService.nonZeroSpaces(maybeStoredStats.get())) {
            StatsStoringService.Stored<ServerStats> storedStats = maybeStoredStats.get();
            if (DefaultStatisticsService.isStoredStatsStale(storedStats.getStoredTime())) {
                this.executor.execute(this::calculateServerStats);
            }
            serverStats = storedStats.getData();
        } else {
            CompletableFuture<ServerStats> future = this.executor.execute(this::calculateServerStats);
            try {
                serverStats = future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new FailedToLoadStatsException("Failed to load server statistics", e);
            }
        }
        return serverStats;
    }

    @Override
    public Collection<SpaceStats> loadSpaceStatistics(Collection<String> spaceKeys) {
        return this.ptx.read(() -> this.contentStatisticsStore.loadSpaceStatistics(spaceKeys));
    }

    @Override
    public SpaceStats loadSpaceStatistics(String spaceKey) {
        return this.ptx.read(() -> this.contentStatisticsStore.loadSpaceStatistics(spaceKey));
    }

    @Override
    public UsersGroupsStats getUsersGroupsStatistics() {
        UsageInfo usageInfo = this.systemInformationService.getUsageInfo();
        int numUsers = usageInfo.getLocalUsers();
        int numGroups = usageInfo.getLocalGroups();
        Duration totalMigrationTime = MigrationTimeEstimationUtils.estimateTotalUserGroupMigrationTime(numUsers, numGroups);
        return new UsersGroupsStats(numUsers, numGroups, totalMigrationTime);
    }

    @VisibleForTesting
    ServerStats calculateServerStats() {
        ConfluenceInfo confluenceInfo = this.systemInformationService.getConfluenceInfo();
        UsageInfo usageInfo = this.systemInformationService.getUsageInfo();
        InstanceStats instanceStats = InstanceStats.builder().version(confluenceInfo.getVersion()).buildNumber(confluenceInfo.getBuildNumber()).numberOfSpaces(usageInfo.getTotalSpaces()).numberOfUsers(usageInfo.getLocalUsers()).numberOfGroups(usageInfo.getLocalGroups()).build();
        Collection<SpaceStats> spaceStats = this.loadSpaceStatistics(this.spaceManager.getAllSpaces().stream().map(Space::getKey).collect(Collectors.toList()));
        List<ContentSummary> spaceSummaries = spaceStats.stream().map(SpaceStats::getSummary).collect(Collectors.toList());
        ContentSummary contentSummary = this.ptx.read(this.contentStatisticsStore::loadContentSummary);
        Duration userGroupMigrationTime = MigrationTimeEstimationUtils.estimateTotalUserGroupMigrationTime(instanceStats.getNumberOfUsers(), instanceStats.getNumberOfGroups());
        Duration spaceMigrationTime = MigrationTimeEstimationUtils.estimateTotalSpaceMigrationTime(spaceSummaries);
        long bandwidthKBPS = NetworkStatisticsService.getUncalculatedBandwidthKBPS();
        if (this.legalService.getRememberLegalOptIn()) {
            bandwidthKBPS = this.networkStatisticsService.measureBandwidthKBPS();
        }
        ServerStats serverStats = new ServerStats(instanceStats, contentSummary, userGroupMigrationTime, spaceMigrationTime, MigrationTimeEstimationUtils.getBaseMigrationTime(), bandwidthKBPS);
        this.statsStoringService.storeServerStats(serverStats);
        return serverStats;
    }
}

