/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.migration.agent.dto.AppInstallInfoRequest;
import com.atlassian.migration.agent.dto.assessment.AppAssessmentStatsResponse;
import com.atlassian.migration.agent.dto.assessment.AppAssessmentUpdateRequest;
import com.atlassian.migration.agent.dto.assessment.AppListResponse;
import com.atlassian.migration.agent.dto.assessment.AppSummaryDto;
import com.atlassian.migration.agent.dto.assessment.AppUsageDto;
import com.atlassian.migration.agent.dto.assessment.CloudAppDto;
import com.atlassian.migration.agent.dto.assessment.TrivalentState;
import com.atlassian.migration.agent.entity.AppAssessmentInfo;
import com.atlassian.migration.agent.entity.AppAssessmentProperty;
import com.atlassian.migration.agent.entity.AppAssessmentUserAttributedStatus;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.service.MigrationAppAggregatorResponse;
import com.atlassian.migration.agent.service.analytics.AppAssessmentAnalyticsEventService;
import com.atlassian.migration.agent.service.app.PluginManager;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.impl.AppUsageService;
import com.atlassian.migration.agent.service.impl.MigrationAppAggregatorService;
import com.atlassian.migration.agent.store.impl.AppAssessmentInfoStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.app.AppMigrationServiceClient;
import com.atlassian.migration.app.dto.AppCloudSiteInfo;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginState;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AppAssessmentService {
    private final MigrationAppAggregatorService appAggregatorService;
    private final AppAssessmentInfoStore appInfoStore;
    private final PluginTransactionTemplate ptx;
    private final PluginManager pluginManager;
    private final AppAssessmentAnalyticsEventService appAssessmentAnalyticsEventService;
    private final AppUsageService appUsageService;
    private final AppMigrationServiceClient amsClient;
    private final CloudSiteService cloudSiteService;
    private static final AppAssessmentUserAttributedStatus DEFAULT_ASSESSMENT_STATUS = AppAssessmentUserAttributedStatus.Unassigned;
    private static final String ASSESSMENT_PROPERTY_DEFAULT_STRING_VALUE = "";

    @Inject
    public AppAssessmentService(MigrationAppAggregatorService appAggregatorService, PluginManager pluginManager, AppAssessmentAnalyticsEventService appAssessmentAnalyticsEventService, AppAssessmentInfoStore appAssessmentInfoStore, PluginTransactionTemplate ptx, AppUsageService appUsageService, AppMigrationServiceClient amsClient, CloudSiteService cloudSiteService) {
        this.appAggregatorService = appAggregatorService;
        this.pluginManager = pluginManager;
        this.appAssessmentAnalyticsEventService = appAssessmentAnalyticsEventService;
        this.appInfoStore = appAssessmentInfoStore;
        this.ptx = ptx;
        this.appUsageService = appUsageService;
        this.amsClient = amsClient;
        this.cloudSiteService = cloudSiteService;
    }

    public AppListResponse<AppSummaryDto> getPlugins() {
        return new AppListResponse<AppSummaryDto>(this.collectAppInfo());
    }

    public AppAssessmentStatsResponse getPluginStats() {
        return new AppAssessmentStatsResponse(this.getAppCount());
    }

    public void updateMigrationStatus(String appKey, AppAssessmentUpdateRequest request) {
        Objects.requireNonNull(request);
        String propName = request.getAppProperty();
        if (!AppAssessmentProperty.isSupported(propName)) {
            throw new IllegalArgumentException(String.format("Unrecognised property name [%s]", propName));
        }
        this.ptx.write(() -> {
            if (this.appInfoStore.getByAppKey(appKey).isPresent()) {
                this.appInfoStore.updateProperty(appKey, propName, this.resolveValueOrDefault(propName, request.getValue(), Object.class));
            } else {
                this.appInfoStore.create(this.toAppAssessmentInfo(appKey, request));
            }
        });
        this.appAssessmentAnalyticsEventService.savePropertyChangedEvent(AuthenticatedUserThreadLocal.get(), appKey, propName);
    }

    public AppListResponse<AppUsageDto> getAppUsageStats() {
        return this.appUsageService.getAppUsageStats();
    }

    public String clearAppUsageCache() {
        return this.appUsageService.clearAppUsageCache();
    }

    public AppListResponse<CloudAppDto> getCloudAppsInfo(AppInstallInfoRequest request) {
        String cloudId = request.getCloudId();
        CloudSite cloudSite = this.cloudSiteService.getByCloudId(cloudId).orElseThrow(() -> new IllegalStateException(String.format("Failed to find cloudSite entry for requested cloudId: %s", cloudId)));
        return new AppListResponse<CloudAppDto>(this.amsClient.getAppInfoForSite(cloudId, request.getAppKeys()).getApps().parallelStream().map(amsApp -> AppAssessmentService.buildCloudAppDto(amsApp, cloudSite.getCloudUrl(), this.appAggregatorService.getCachedCloudAppData(amsApp.getKey()))).collect(Collectors.toList()));
    }

    public static boolean isPluginEnabled(Plugin plugin) {
        return PluginState.ENABLED == plugin.getPluginState();
    }

    private List<AppSummaryDto> collectAppInfo() {
        Map assessedPlugins = this.appInfoStore.getAll().stream().collect(Collectors.toMap(AppAssessmentInfo::getAppKey, Function.identity()));
        List<AppSummaryDto> collect = this.pluginManager.getActualUserInstalledPlugins().parallelStream().map(plugin -> this.buildPluginData((Plugin)plugin, assessedPlugins)).collect(Collectors.toList());
        this.appAssessmentAnalyticsEventService.saveAppsFetchedEvent(collect.stream().map(AppSummaryDto::getKey).collect(Collectors.toList()), AuthenticatedUserThreadLocal.get());
        return collect;
    }

    private long getAppCount() {
        return this.pluginManager.getActualUserInstalledPlugins().size();
    }

    private AppSummaryDto buildPluginData(Plugin plugin, Map<String, AppAssessmentInfo> assessedPlugins) {
        String appKey = plugin.getKey();
        AppAssessmentInfo appAssessmentInfo = assessedPlugins.get(appKey);
        AppAssessmentUserAttributedStatus migrationStatus = null;
        String migrationNotes = null;
        String alternativeAppKey = null;
        if (appAssessmentInfo != null) {
            migrationStatus = appAssessmentInfo.getMigrationStatus();
            migrationNotes = appAssessmentInfo.getMigrationNotes();
            alternativeAppKey = appAssessmentInfo.getAlternativeAppKey();
        }
        MigrationAppAggregatorResponse appAggregatorResponse = this.appAggregatorService.getCachedServerAppData(appKey);
        return new AppSummaryDto(plugin.getKey(), plugin.getName(), appAggregatorResponse.getIcon(), appAggregatorResponse.getCloudUrl(), appAggregatorResponse.getCloudKey(), AppAssessmentService.isPluginEnabled(plugin), appAggregatorResponse.hasCloud(), TrivalentState.fromFeatureDifference(appAggregatorResponse.getFeatureDifference()), TrivalentState.fromMigratable(appAggregatorResponse.getMigratable()), appAggregatorResponse.getFeatureDifferenceUrl(), appAggregatorResponse.getMigrationPathInstructions(), appAggregatorResponse.getContactSupportUrl(), this.resolveValueOrDefault(AppAssessmentProperty.MIGRATION_STATUS.getName(), (Object)migrationStatus, AppAssessmentUserAttributedStatus.class), this.resolveValueOrDefault(AppAssessmentProperty.MIGRATION_NOTES.getName(), migrationNotes, String.class), this.resolveValueOrDefault(AppAssessmentProperty.ALTERNATIVE_APP_KEY.getName(), alternativeAppKey, String.class));
    }

    private <T> T resolveValueOrDefault(String propName, Object value, Class<T> returnType) {
        T transformedValue = null;
        switch (AppAssessmentProperty.getAppAssessmentPropertyByName(propName)) {
            case MIGRATION_STATUS: {
                if (value instanceof String) {
                    transformedValue = returnType.cast((Object)AppAssessmentUserAttributedStatus.valueOf((String)value));
                    break;
                }
                if (value instanceof AppAssessmentUserAttributedStatus) {
                    transformedValue = returnType.cast(value);
                    break;
                }
                transformedValue = returnType.cast((Object)DEFAULT_ASSESSMENT_STATUS);
                break;
            }
            case MIGRATION_NOTES: 
            case ALTERNATIVE_APP_KEY: {
                transformedValue = returnType.cast(Optional.ofNullable(value).orElse(ASSESSMENT_PROPERTY_DEFAULT_STRING_VALUE));
            }
        }
        return transformedValue;
    }

    private AppAssessmentInfo toAppAssessmentInfo(String appKey, AppAssessmentUpdateRequest request) {
        return new AppAssessmentInfo(appKey, this.resolveValueOrDefault(AppAssessmentProperty.MIGRATION_STATUS.getName(), AppAssessmentService.maybeValue(request, AppAssessmentProperty.MIGRATION_STATUS), AppAssessmentUserAttributedStatus.class), this.resolveValueOrDefault(AppAssessmentProperty.MIGRATION_NOTES.getName(), AppAssessmentService.maybeValue(request, AppAssessmentProperty.MIGRATION_NOTES), String.class), this.resolveValueOrDefault(AppAssessmentProperty.ALTERNATIVE_APP_KEY.getName(), AppAssessmentService.maybeValue(request, AppAssessmentProperty.ALTERNATIVE_APP_KEY), String.class));
    }

    private static String maybeValue(AppAssessmentUpdateRequest request, AppAssessmentProperty propertyToCheck) {
        return request.getAppProperty().equals(propertyToCheck.getName()) ? request.getValue() : null;
    }

    private static CloudAppDto buildCloudAppDto(AppCloudSiteInfo amsApp, String cloudUrl, MigrationAppAggregatorResponse maaApp) {
        return new CloudAppDto(amsApp.getKey(), maaApp.getName(), maaApp.getIcon(), maaApp.getCloudUrl(), AppAssessmentService.buildSiteAppInstallationUrl(cloudUrl, maaApp.getRelativeInstallUrl()), maaApp.getPrivacyPolicyUrl(), maaApp.getContactSupportUrl(), amsApp.isInstalled());
    }

    private static String buildSiteAppInstallationUrl(String siteUrl, String appInstallationSuffix) {
        return siteUrl + "/" + appInstallationSuffix;
    }
}

