/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.email;

import com.atlassian.cmpt.check.email.EmailCheckContext;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.impl.UserService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@ParametersAreNonnullByDefault
class EmailCheckContextProvider
implements CheckContextProvider<EmailCheckContext> {
    private final UserService userService;

    @Inject
    EmailCheckContextProvider(UserService userService) {
        this.userService = userService;
    }

    @Override
    public EmailCheckContext apply(Map<String, Object> parameters) {
        List emails = this.userService.getAllUsers().stream().map(u -> new EmailData(u.getUsername(), u.getEmail())).collect(Collectors.toList());
        return new EmailCheckContext(emails);
    }
}

