/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.email;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.email.EmailCheckContext;
import com.atlassian.cmpt.check.email.EmailFormatChecker;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;
import com.atlassian.cmpt.check.mapper.EmailFormatDataProvider;
import com.atlassian.cmpt.check.mapper.EmailFormatMapper;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistration;
import com.atlassian.migration.agent.service.check.email.EmailCheckContextProvider;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.web.util.UriComponentsBuilder;

@ParametersAreNonnullByDefault
abstract class AbstractInvalidEmailCheckRegistration
implements CheckRegistration<EmailCheckContext> {
    private static final String PATH = "/admin/users/edituser.action";
    private final EmailFormatChecker checker;
    private final EmailCheckContextProvider contextProvider;
    private final EmailFormatMapper resultMapper;
    private final AnalyticsEventBuilder analyticsEventBuilder;

    AbstractInvalidEmailCheckRegistration(EmailCheckContextProvider contextProvider, SystemInformationService systemInformationService, AnalyticsEventBuilder analyticsEventBuilder) {
        this.contextProvider = contextProvider;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.checker = new EmailFormatChecker();
        ConfluenceInfo confluenceInfo = systemInformationService.getConfluenceInfo();
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)confluenceInfo.getBaseUrl()).path(PATH);
        this.resultMapper = this.buildEmailFormatMapper(username -> uriBuilder.replaceQueryParam("username", new Object[]{username}).toUriString());
    }

    abstract EmailFormatMapper buildEmailFormatMapper(EmailFormatDataProvider var1);

    @Override
    public Checker<EmailCheckContext> getChecker() {
        return this.checker;
    }

    @Override
    public CheckResultMapper getCheckResultMapper() {
        return this.resultMapper;
    }

    @Override
    public CheckContextProvider<EmailCheckContext> getCheckContextProvider() {
        return this.contextProvider;
    }

    @Override
    public EventDto getAnalyticsEventModel(CheckResult checkResult, long totalTime) {
        return this.analyticsEventBuilder.buildPreflightInvalidEmails(checkResult.success, EmailFormatChecker.retrieveInvalidEmails((Map)checkResult.details), totalTime);
    }

    @Override
    public String getFailedToExecuteAnalyticsEventName() {
        return "invalidEmailsCheck";
    }
}

