/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CheckType {
    public static CheckType INVALID_EMAILS = new CheckType("InvalidEmails", true);
    public static CheckType SHARED_EMAILS = new CheckType("SharedEmails", true);
    public static CheckType SPACES_INVALID_EMAILS = new CheckType("SpacesInvalidEmails");
    public static CheckType SPACES_SHARED_EMAILS = new CheckType("SpacesSharedEmails");
    public static CheckType APP_OUTDATED = new CheckType("AppOutdated", true);
    public static CheckType SPACE_KEYS_CONFLICT = new CheckType("SpaceKeysConflict", true);
    public static CheckType GROUP_NAMES_CONFLICT = new CheckType("GroupNamesConflict");
    public static CheckType CLOUD_FREE_USERS_CONFLICT = new CheckType("CloudFreeUsersConflict");
    private static Set<CheckType> staticCheckTypes = new HashSet<CheckType>();
    private final String value;
    private boolean blocksMigration = false;

    private CheckType(String value) {
        this.value = value;
    }

    private CheckType(String value, boolean blocksMigration) {
        this.value = value;
        this.blocksMigration = blocksMigration;
    }

    public static Set<CheckType> getStaticCheckTypes() {
        return staticCheckTypes;
    }

    public String value() {
        return this.value;
    }

    public static CheckType fromString(String value) {
        return staticCheckTypes.stream().filter(it -> it.value().equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Check type [%s] not found", value)));
    }

    public boolean blocksMigration() {
        return this.blocksMigration;
    }

    static {
        staticCheckTypes.addAll(Arrays.asList(INVALID_EMAILS, SHARED_EMAILS, SPACES_INVALID_EMAILS, SPACES_SHARED_EMAILS, APP_OUTDATED, SPACE_KEYS_CONFLICT, GROUP_NAMES_CONFLICT, CLOUD_FREE_USERS_CONFLICT));
    }
}

