/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;
import com.atlassian.migration.agent.dto.ConfluenceSpaceTaskDto;
import com.atlassian.migration.agent.dto.MigrateUsersTaskDto;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.service.check.CheckRegistry;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.free.CloudFreeUsersConflictMapper;
import com.atlassian.migration.agent.service.check.group.GroupNamesConflictMapper;
import com.atlassian.migration.app.InternalPreflightCheckResult;
import com.atlassian.migration.app.dto.AppPreflightResult;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;

@Singleton
@ParametersAreNonnullByDefault
public class CheckTransformerService {
    private static final String CLOUD_ID_KEY = "cloudId";
    private static final String SPACES_KEY = "spaceKeys";
    private final CheckRegistry checkerRegistry;

    @Inject
    CheckTransformerService(CheckRegistry checkRegistry) {
        this.checkerRegistry = checkRegistry;
    }

    public List<CheckRequest> getCheckRequests(PlanDto planDto) {
        return this.getCheckRequests(planDto, Collections.emptySet());
    }

    public List<CheckRequest> getCheckRequests(PlanDto planDto, Set<CheckType> requestedChecks) {
        Set<CheckType> checksToPerform = CollectionUtils.isEmpty(requestedChecks) ? CheckType.getStaticCheckTypes() : requestedChecks;
        List checkRequests = checksToPerform.stream().map(this::resolveCheckRequest).map(checkBuilder -> (Optional)checkBuilder.apply(planDto)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(ArrayList::new));
        this.addFreeCheckIfRequired(planDto, checkRequests);
        return checkRequests;
    }

    public List<CheckResultDto> toCheckResultDtos(List<CheckStatus> statuses) {
        List results = statuses.stream().map(this::convertToCheckResultDto).collect(Collectors.toCollection(ArrayList::new));
        this.filterOutFreeCheckResultIfRequired(results);
        return results;
    }

    public Collection<CheckResultDto> toCheckResultDtos(Collection<AppPreflightResult> preflightResults) {
        return preflightResults.stream().map(it -> this.transform((AppPreflightResult)it)).collect(Collectors.toList());
    }

    private CheckResultDto transform(AppPreflightResult it) {
        CheckResultDto checkResultDto = new CheckResultDto();
        checkResultDto.setCheckType("app-migration:" + it.getPluginKey());
        checkResultDto.setStatus(this.convertStatus(it.getVendorResult().getStatus()));
        checkResultDto.setLastExecution(Long.valueOf(it.getExecutedAt()));
        checkResultDto.setDescription("Preflight check for " + it.getPluginKey());
        CheckDetailsDto details = new CheckDetailsDto();
        checkResultDto.setDetails(details);
        return checkResultDto;
    }

    private Status convertStatus(InternalPreflightCheckResult.PreflightCheckStatus status) {
        switch (status) {
            case OK: {
                return Status.SUCCESS;
            }
            case WARNING: {
                return Status.WARNING;
            }
            case BLOCKER: {
                return Status.ERROR;
            }
        }
        return Status.RUNNING;
    }

    private CheckResultDto convertToCheckResultDto(CheckStatus checkStatus) {
        CheckType checkType = CheckType.fromString(checkStatus.checkType);
        CheckResultMapper mapper = this.checkerRegistry.getResultMapper(checkType);
        return mapper.map(checkStatus);
    }

    private Function<PlanDto, Optional<CheckRequest>> resolveCheckRequest(CheckType checkType) {
        String value = checkType.value();
        if (value.equals(CheckType.APP_OUTDATED.value())) {
            return CheckTransformerService::buildAppOutdatedCheck;
        }
        if (value.equals(CheckType.GROUP_NAMES_CONFLICT.value())) {
            return CheckTransformerService::buildGroupNamesCheck;
        }
        if (value.equals(CheckType.INVALID_EMAILS.value())) {
            return CheckTransformerService::buildInvalidEmailsCheck;
        }
        if (value.equals(CheckType.CLOUD_FREE_USERS_CONFLICT.value())) {
            return CheckTransformerService::buildCloudFreeCheck;
        }
        if (value.equals(CheckType.SHARED_EMAILS.value())) {
            return CheckTransformerService::buildSharedEmailsCheck;
        }
        if (value.equals(CheckType.SPACES_INVALID_EMAILS.value())) {
            return CheckTransformerService::buildSpacesInvalidEmailsCheck;
        }
        if (value.equals(CheckType.SPACES_SHARED_EMAILS.value())) {
            return CheckTransformerService::buildSpacesSharedEmailsCheck;
        }
        if (value.equals(CheckType.SPACE_KEYS_CONFLICT.value())) {
            return CheckTransformerService::buildSpaceKeysCheck;
        }
        throw new IllegalArgumentException(String.format("Check type %s is not supported yet", checkType));
    }

    private static Optional<CheckRequest> buildAppOutdatedCheck(PlanDto planDto) {
        return Optional.of(new CheckRequest(CheckType.APP_OUTDATED.value(), Collections.emptyMap()));
    }

    private static Optional<CheckRequest> buildInvalidEmailsCheck(PlanDto planDto) {
        if (CheckTransformerService.hasUsersGroupsTask(planDto)) {
            return Optional.of(new CheckRequest(CheckType.INVALID_EMAILS.value(), Collections.emptyMap()));
        }
        return Optional.empty();
    }

    private static Optional<CheckRequest> buildSpacesInvalidEmailsCheck(PlanDto planDto) {
        if (!CheckTransformerService.hasUsersGroupsTask(planDto)) {
            return Optional.of(new CheckRequest(CheckType.SPACES_INVALID_EMAILS.value(), Collections.emptyMap()));
        }
        return Optional.empty();
    }

    private static Optional<CheckRequest> buildSharedEmailsCheck(PlanDto planDto) {
        if (CheckTransformerService.hasUsersGroupsTask(planDto)) {
            return Optional.of(new CheckRequest(CheckType.SHARED_EMAILS.value(), Collections.emptyMap()));
        }
        return Optional.empty();
    }

    private static Optional<CheckRequest> buildSpacesSharedEmailsCheck(PlanDto planDto) {
        if (!CheckTransformerService.hasUsersGroupsTask(planDto)) {
            return Optional.of(new CheckRequest(CheckType.SPACES_SHARED_EMAILS.value(), Collections.emptyMap()));
        }
        return Optional.empty();
    }

    private static Optional<CheckRequest> buildGroupNamesCheck(PlanDto planDto) {
        if (CheckTransformerService.hasUsersGroupsTask(planDto)) {
            return Optional.of(new CheckRequest(CheckType.GROUP_NAMES_CONFLICT.value(), (Map)ImmutableMap.of((Object)CLOUD_ID_KEY, (Object)planDto.getCloudSite().getCloudId())));
        }
        return Optional.empty();
    }

    private static Optional<CheckRequest> buildSpaceKeysCheck(PlanDto planDto) {
        String commaSeparatedSpaceKeys = planDto.getTasks().stream().filter(ConfluenceSpaceTaskDto.class::isInstance).map(taskDto -> ((ConfluenceSpaceTaskDto)taskDto).getSpace()).collect(Collectors.joining(","));
        if (commaSeparatedSpaceKeys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new CheckRequest(CheckType.SPACE_KEYS_CONFLICT.value(), (Map)ImmutableMap.of((Object)CLOUD_ID_KEY, (Object)planDto.getCloudSite().getCloudId(), (Object)SPACES_KEY, (Object)commaSeparatedSpaceKeys)));
    }

    private static Optional<CheckRequest> buildCloudFreeCheck(PlanDto planDto) {
        if (CheckTransformerService.hasUsersGroupsTask(planDto)) {
            return Optional.of(new CheckRequest(CheckType.CLOUD_FREE_USERS_CONFLICT.value(), (Map)ImmutableMap.of((Object)CLOUD_ID_KEY, (Object)planDto.getCloudSite().getCloudId())));
        }
        return Optional.empty();
    }

    private static boolean hasUsersGroupsTask(PlanDto planDto) {
        return planDto.getTasks().stream().anyMatch(MigrateUsersTaskDto.class::isInstance);
    }

    private void addFreeCheckIfRequired(PlanDto planDto, List<CheckRequest> checkRequests) {
        boolean freeCheckAlreadyInTheList = checkRequests.stream().anyMatch(c -> CheckType.CLOUD_FREE_USERS_CONFLICT.value().equals(c.checkType));
        if (freeCheckAlreadyInTheList) {
            return;
        }
        boolean groupNameCheckInTheList = checkRequests.stream().anyMatch(c -> CheckType.GROUP_NAMES_CONFLICT.value().equals(c.checkType));
        if (!groupNameCheckInTheList) {
            return;
        }
        CheckTransformerService.buildCloudFreeCheck(planDto).ifPresent(checkRequests::add);
    }

    private void filterOutFreeCheckResultIfRequired(List<CheckResultDto> results) {
        Optional<CheckResultDto> maybeResultFree = this.findByCheckType(CheckType.CLOUD_FREE_USERS_CONFLICT, results);
        if (!maybeResultFree.isPresent()) {
            return;
        }
        CheckResultDto freeResult = maybeResultFree.get();
        Optional<CheckResultDto> maybeGroupNameResult = this.findByCheckType(CheckType.GROUP_NAMES_CONFLICT, results);
        if (!maybeGroupNameResult.isPresent()) {
            return;
        }
        CheckResultDto groupNameResult = maybeGroupNameResult.get();
        Status freeStatus = freeResult.getStatus();
        if (freeStatus == Status.RUNNING) {
            GroupNamesConflictMapper.convertToRunning(groupNameResult);
        }
        if (freeStatus == Status.RUNNING || freeStatus == Status.EXECUTION_ERROR || freeStatus == Status.SUCCESS && !CloudFreeUsersConflictMapper.hasEditionChanged(freeResult)) {
            results.removeIf(r -> CheckType.CLOUD_FREE_USERS_CONFLICT.value().equals(r.getCheckType()));
        }
    }

    private Optional<CheckResultDto> findByCheckType(CheckType checkType, List<CheckResultDto> results) {
        return results.stream().filter(r -> checkType.value().equals(r.getCheckType())).findAny();
    }
}

