/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.app;

import com.atlassian.migration.agent.service.impl.MigrationAppAggregatorService;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PluginManager {
    private final PluginAccessor pluginAccessor;
    private final PluginMetadataManager pluginMetadataManager;
    private final MigrationAppAggregatorService migrationAppAggregatorService;

    @Inject
    public PluginManager(PluginAccessor pluginAccessor, PluginMetadataManager pluginMetadataManager, MigrationAppAggregatorService migrationAppAggregatorService) {
        this.pluginAccessor = pluginAccessor;
        this.pluginMetadataManager = pluginMetadataManager;
        this.migrationAppAggregatorService = migrationAppAggregatorService;
    }

    public Collection<Plugin> getActualUserInstalledPlugins() {
        this.migrationAppAggregatorService.validateAndReloadBlacklist();
        return this.pluginAccessor.getPlugins().parallelStream().filter(arg_0 -> ((PluginMetadataManager)this.pluginMetadataManager).isUserInstalled(arg_0)).filter(plugin -> !this.migrationAppAggregatorService.isBlacklisted(plugin.getKey())).collect(Collectors.toList());
    }

    public Plugin getPlugin(String appKey) {
        return this.pluginAccessor.getPlugin(appKey);
    }
}

