/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.AttachmentMigration;
import com.atlassian.migration.agent.store.AttachmentMigrationStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.Page;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AttachmentMigrationStoreImpl
implements AttachmentMigrationStore {
    private static final String CLOUD_ID_KEY = "cloudId";
    private final EntityManagerTemplate tmpl;

    @Inject
    public AttachmentMigrationStoreImpl(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public void saveMigration(AttachmentMigration attachmentMigration) {
        this.tmpl.merge(attachmentMigration);
        this.tmpl.flush();
    }

    @Override
    public Optional<AttachmentMigration> findMigration(long attachmentId, String cloudId) {
        String query = "select a from AttachmentMigration a where a.cloudId = :cloudId and a.attachmentId = :attachmentId";
        return this.tmpl.query(AttachmentMigration.class, query).param(CLOUD_ID_KEY, (Object)cloudId).param("attachmentId", (Object)attachmentId).first();
    }

    @Override
    public int deleteMigrationsByCloudId(String cloudId) {
        String query = "delete from AttachmentMigration m where m.cloudId=:cloudId";
        return this.tmpl.query(query).param(CLOUD_ID_KEY, (Object)cloudId).update();
    }

    @Override
    public Page<AttachmentMigration> listMigrations(String cloudId, String spaceKey, int pageSize) {
        String jpql = "select am from AttachmentMigration am join am.attachment a join a.space s ON s.key = :spaceKey where am.mediaId is not NULL and am.cloudSite.cloudId = :cloudId order by a.id";
        return this.tmpl.query(AttachmentMigration.class, jpql).param(CLOUD_ID_KEY, (Object)cloudId).param("spaceKey", (Object)spaceKey).page(pageSize);
    }
}

