/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.attachment;

import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.store.AttachmentMigrationCandidate;
import com.atlassian.migration.agent.store.jpa.Page;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;

class AttachmentsToMigrateProducer
implements Runnable {
    private static final Logger log = ContextLoggerFactory.getLogger(AttachmentsToMigrateProducer.class);
    private final BlockingQueue<AttachmentMigrationCandidate> buffer;
    private Page<AttachmentMigrationCandidate> attachmentPage;
    private final BooleanSupplier forceStop;

    AttachmentsToMigrateProducer(Page<AttachmentMigrationCandidate> attachmentPage, BlockingQueue<AttachmentMigrationCandidate> buffer, BooleanSupplier forceStop) {
        this.buffer = buffer;
        this.attachmentPage = attachmentPage;
        this.forceStop = forceStop;
    }

    @Override
    public void run() {
        while (this.canRun() && this.attachmentPage.hasContent()) {
            List<AttachmentMigrationCandidate> attachmentCandidates = this.attachmentPage.getContent();
            log.info("Loaded {} attachments to upload from DB", (Object)attachmentCandidates.size());
            for (AttachmentMigrationCandidate attachment : attachmentCandidates) {
                boolean added = false;
                while (!added && this.canRun()) {
                    added = this.addToBuffer(attachment);
                    if (!added) continue;
                    log.info("Added attachment {} to upload buffer", (Object)attachment.getAttachment().getId());
                }
            }
            this.attachmentPage = this.attachmentPage.next();
        }
    }

    private boolean canRun() {
        return !this.forceStop.getAsBoolean();
    }

    private boolean addToBuffer(AttachmentMigrationCandidate attachmentCandidate) {
        try {
            return this.buffer.offer(attachmentCandidate, 200L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to add attachment to buffer because action was interrupted.", ex);
        }
    }
}

