/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.cmpt.check.base.CheckExecutionStatus;
import com.atlassian.cmpt.check.base.CheckExecutor;
import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.ChecksResultDto;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.LoggingContextBuilder;
import com.atlassian.migration.agent.rest.MessageDto;
import com.atlassian.migration.agent.service.check.CheckResultsService;
import com.atlassian.migration.agent.service.check.CheckTransformerService;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@Path(value="check")
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CheckResource {
    private static final Logger log = ContextLoggerFactory.getLogger(CheckResource.class);
    private final CheckExecutor checkExecutor;
    private final CheckResultsService checkResultService;
    private final CheckTransformerService checkTransformerService;

    public CheckResource(CheckExecutor checkExecutor, CheckResultsService checkResultService, CheckTransformerService checkTransformerService) {
        this.checkExecutor = checkExecutor;
        this.checkResultService = checkResultService;
        this.checkTransformerService = checkTransformerService;
    }

    @GET
    @Path(value="/{executionId}/status")
    public Response getCheckExecutionStatus(@PathParam(value="executionId") String executionId) {
        return LoggingContextBuilder.logCtx().withCheckExecutionId(executionId).execute(() -> {
            Optional maybeStatus = this.checkExecutor.getStatus(executionId);
            if (!maybeStatus.isPresent()) {
                log.warn("Check execution not found.");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new MessageDto(String.format("Check execution with id = %s not found", executionId))).build();
            }
            List<CheckResultDto> results = this.checkTransformerService.toCheckResultDtos(((CheckExecutionStatus)maybeStatus.get()).statuses);
            return Response.ok((Object)new ChecksResultDto(results)).build();
        });
    }

    @POST
    @Path(value="/{executionId}")
    public Response executeChecks(@PathParam(value="executionId") String executionId, @QueryParam(value="type") Set<CheckType> types, PlanDto planDto) {
        return LoggingContextBuilder.logCtx().withCheckExecutionId(executionId).execute(() -> {
            List<CheckRequest> checkRequests = this.checkTransformerService.getCheckRequests(planDto, types);
            if (checkRequests.isEmpty()) {
                log.warn("No checks are to be scheduled");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new MessageDto("No checks are to be scheduled")).build();
            }
            if (CollectionUtils.isEmpty((Collection)types)) {
                this.checkResultService.deleteCheckResultsByExecutionId(executionId);
            }
            this.checkExecutor.executeChecks(executionId, checkRequests);
            log.info("Scheduled checks: {}", (Object)checkRequests.stream().map(ch -> ch.checkType).collect(Collectors.joining(", ")));
            return Response.ok().build();
        });
    }

    @DELETE
    @Path(value="/{executionId}")
    public Response deleteCheckExecutionResults(@PathParam(value="executionId") String executionId) {
        return LoggingContextBuilder.logCtx().withCheckExecutionId(executionId).execute(() -> {
            this.checkResultService.deleteCheckResultsByExecutionId(executionId);
            log.info("Check execution is deleted.");
            return Response.ok().build();
        });
    }
}

