/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.messagequeue;

import com.atlassian.annotations.PublicApi;
import com.atlassian.messagequeue.MessageRunnerKey;
import java.util.Objects;
import java.util.Optional;

@PublicApi
public final class Message {
    private final MessageRunnerKey runnerKey;
    private final Optional<String> payload;

    private Message(MessageRunnerKey runnerKey, Optional<String> payload) {
        this.runnerKey = Objects.requireNonNull(runnerKey, "runnerKey");
        this.payload = Objects.requireNonNull(payload, "payload");
    }

    public MessageRunnerKey getRunnerKey() {
        return this.runnerKey;
    }

    public Optional<String> getPayload() {
        return this.payload;
    }

    public static Message create(MessageRunnerKey runnerKey, String payload) {
        return Message.builder(runnerKey).payload(payload).build();
    }

    public static Builder builder(MessageRunnerKey runnerKey) {
        return new Builder(runnerKey);
    }

    @PublicApi
    public static class Builder {
        private final MessageRunnerKey runnerKey;
        private Optional<String> payload = Optional.empty();

        public Builder(MessageRunnerKey runnerKey) {
            this.runnerKey = Objects.requireNonNull(runnerKey, "runnerKey");
        }

        public Message build() {
            return new Message(this.runnerKey, this.payload);
        }

        public Builder payload(String payload) {
            this.payload = Optional.ofNullable(payload);
            return this;
        }
    }
}

