package com.atlassian.messagequeue.registry;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.messagequeue.MessageRunnerService;

/**
 * Message Runner SPI. Implementations of Message Runners should implement this interface.
 * @since 1.0
 */
@PublicSpi
public interface MessageRunner {

    /**
     * <p>
     *     Entry point for running this message.
     * </p>
     * <p>
     *     A WorkContext and tenant context (as per the workcontext api) will be established before handleMessage()
     *     is called. This workcontext will be forcibly torn down when handleMessage() returns.
     * </p>
     * <p>
     *     To signify success or failure, a message should communicate via some token in its payload - eg the ID of a DB
     *     record.
     * </p>
     * <p>
     *     If an exception is thrown by an implementor of this method, the message system may retry processing the
     *     message later. Whether retries are attempted, the number of retries, and the interval between retries
     *     is up to the configuration of the {@link MessageRunnerService} implementation.
     * <p>
     * @param context Message execution context
     */
    void processMessage(MessageContext context);
}