package com.atlassian.messagequeue.registry;

import com.atlassian.annotations.PublicApi;

import java.util.Optional;

/**
 * Context that is passed to an execution of a message. This contains all information that is required by handlers of
 * the message.
 * @since 1.0
 */
@PublicApi
public interface MessageContext {

    /**
     * @return the payload that should be given to an executable message
     */
    Optional<String> getPayload();
}