/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.media.client.impl;

import com.atlassian.media.client.ConnectionDetail;
import com.atlassian.media.client.api.MediaApiClient;
import com.atlassian.media.client.impl.HttpClientMediaApiClient;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class MediaApiClientFactory {
    public static MediaApiClient createClient(String endpoint) {
        return MediaApiClientFactory.createClient(endpoint, ConnectionDetail.Builder.defaultBuilder().build());
    }

    public static MediaApiClient createClient(String endpoint, ConnectionDetail connectionDetail) {
        return MediaApiClientFactory.createClient(endpoint, connectionDetail, Collections.emptyList(), Collections.emptyList());
    }

    public static MediaApiClient createClient(String endpoint, ConnectionDetail connectionDetail, Iterable<HttpRequestInterceptor> requestInterceptors, Iterable<HttpResponseInterceptor> responseInterceptors) {
        if (Objects.requireNonNull(endpoint).endsWith("/")) {
            return new HttpClientMediaApiClient(endpoint.replaceAll("/+$", ""), MediaApiClientFactory.initializeHttpClient(Objects.requireNonNull(connectionDetail), requestInterceptors, responseInterceptors));
        }
        return new HttpClientMediaApiClient(endpoint, MediaApiClientFactory.initializeHttpClient(Objects.requireNonNull(connectionDetail), requestInterceptors, responseInterceptors));
    }

    private static CloseableHttpClient initializeHttpClient(ConnectionDetail connectionConfig, Iterable<HttpRequestInterceptor> requestInterceptors, Iterable<HttpResponseInterceptor> responseInterceptors) {
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager((long)connectionConfig.getConnectionTimeToLive(), TimeUnit.MILLISECONDS);
        connManager.setMaxTotal(connectionConfig.getMaxConnections());
        connManager.setDefaultMaxPerRoute(connectionConfig.getMaxConnectionsPerRoute());
        RequestConfig.Builder defaultRequestConfigBuilder = RequestConfig.custom().setConnectTimeout(connectionConfig.getConnectTimeout()).setSocketTimeout(connectionConfig.getSocketTimeout());
        String proxyUrl = connectionConfig.getProxyUrl();
        if (proxyUrl != null && !proxyUrl.isEmpty()) {
            defaultRequestConfigBuilder.setProxy(HttpHost.create((String)proxyUrl));
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(defaultRequestConfigBuilder.build());
        for (HttpRequestInterceptor reqInter : requestInterceptors) {
            httpClientBuilder.addInterceptorFirst(reqInter);
        }
        for (HttpResponseInterceptor respInter : responseInterceptors) {
            httpClientBuilder.addInterceptorFirst(respInter);
        }
        return httpClientBuilder.build();
    }
}

