/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.media.client.impl;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.media.client.MediaApiRoute;
import com.atlassian.media.client.api.Failure;
import com.atlassian.media.client.api.MediaApiClient;
import com.atlassian.media.client.api.Success;
import com.atlassian.media.client.api.entity.ArtifactType;
import com.atlassian.media.client.api.entity.ByteRange;
import com.atlassian.media.client.api.entity.ChunkETag;
import com.atlassian.media.client.api.entity.ClientDetail;
import com.atlassian.media.client.api.entity.ClientIdentity;
import com.atlassian.media.client.api.entity.Entity;
import com.atlassian.media.client.api.entity.EntityResult;
import com.atlassian.media.client.util.AuthenticationUtil;
import com.atlassian.media.client.util.ClientIdentityDeserializer;
import com.atlassian.media.client.util.DigestUtils;
import com.atlassian.media.client.util.EntityDeserializer;
import com.atlassian.media.client.util.UrnHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.module.SimpleModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientMediaApiClient
implements MediaApiClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClientMediaApiClient.class);
    private final CloseableHttpClient client;
    private final String endpoint;
    private final ObjectMapper mapper;

    HttpClientMediaApiClient(String endpoint, CloseableHttpClient httpClient) {
        this.endpoint = Objects.requireNonNull(endpoint);
        this.client = Objects.requireNonNull(httpClient);
        this.mapper = HttpClientMediaApiClient.initializeJsonMapper();
    }

    private static ObjectMapper initializeJsonMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new SimpleModule("Media API-client-core", Version.unknownVersion()).addDeserializer(Entity.class, (JsonDeserializer)new EntityDeserializer()).addDeserializer(ClientIdentity.class, (JsonDeserializer)new ClientIdentityDeserializer()));
        return mapper;
    }

    public Either<Failure, Success<Entity>> getFile(ClientIdentity identity, String fileId) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(fileId);
        log.debug("Retrieving metadata for file with id {}", (Object)fileId);
        try {
            return (Either)this.client.execute((HttpUriRequest)this.signedRequest((HttpRequestBase)new HttpGet(MediaApiRoute.GET_FILE_METADATA.getUrl(new String[]{this.endpoint, fileId})), identity, UrnHelper.toReadFile((String)fileId)), (ResponseHandler)new ResponseHandler<Either<Failure, Success<Entity>>>(){

                public Either<Failure, Success<Entity>> handleResponse(HttpResponse response) throws IOException {
                    return HttpClientMediaApiClient.this.translateResponse(response, 200, new ResultMapper<Entity>(){

                        @Override
                        public Entity apply(HttpResponse response) throws IOException {
                            return (Entity)HttpClientMediaApiClient.this.mapper.readValue(response.getEntity().getContent(), Entity.class);
                        }
                    });
                }
            });
        }
        catch (IOException exc) {
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.TRANSPORT_ERROR).cause((Throwable)exc).build());
        }
    }

    public Either<Failure, Success<Entity>> uploadFile(ClientIdentity identity, InputStream file, @Nullable String name) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(file);
        log.debug("Uploading file with name {}", (Object)name);
        HttpPost uploader = new HttpPost(name == null ? MediaApiRoute.POST_FILE_BINARY.getUrl(new String[]{this.endpoint}) : MediaApiRoute.POST_FILE_BINARY_WITH_NAME.getUrl(new String[]{this.endpoint, name}));
        uploader.setEntity((HttpEntity)new InputStreamEntity(file, ContentType.APPLICATION_OCTET_STREAM));
        return this.createFile(this.signedRequest((HttpRequestBase)uploader, identity, UrnHelper.toCreateFile()));
    }

    public Either<Failure, Success<EntityResult>> downloadOriginalFile(ClientIdentity identity, String fileId) {
        return this.downloadOriginalFile(Objects.requireNonNull(identity), Objects.requireNonNull(fileId), null);
    }

    public Either<Failure, Success<EntityResult>> downloadOriginalFile(ClientIdentity identity, String fileId, @Nullable ByteRange range) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(fileId);
        log.debug("Downloading original file with id {}", (Object)fileId);
        return this.downloadFile(identity, MediaApiRoute.GET_FILE_BINARY.getUrl(new String[]{this.endpoint, fileId}), fileId, range);
    }

    public Either<Failure, Success<EntityResult>> downloadArtifact(ClientIdentity identity, String fileId, ArtifactType artifactType) {
        return this.downloadArtifact(Objects.requireNonNull(identity), Objects.requireNonNull(fileId), Objects.requireNonNull(artifactType), null);
    }

    public Either<Failure, Success<EntityResult>> downloadArtifact(ClientIdentity identity, String fileId, ArtifactType artifactType, @Nullable ByteRange range) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(fileId);
        Objects.requireNonNull(artifactType);
        log.debug("Downloading an artifact of type {}, file Id: {}", (Object)artifactType, (Object)fileId);
        return this.downloadFile(identity, MediaApiRoute.GET_ARTIFACT_BINARY.getUrl(new String[]{this.endpoint, fileId, artifactType.getFileName()}), fileId, range);
    }

    public Either<Failure, Success<Void>> deleteFile(ClientIdentity identity, String fileId) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(fileId);
        log.debug("Deleting file with id {}", (Object)fileId);
        HttpDelete method = new HttpDelete(MediaApiRoute.GET_FILE_METADATA.getUrl(new String[]{this.endpoint, fileId}));
        try {
            return (Either)this.client.execute((HttpUriRequest)this.signedRequest((HttpRequestBase)method, identity, UrnHelper.toDeleteFile((String)fileId)), (ResponseHandler)new ResponseHandler<Either<Failure, Success<Void>>>(){

                public Either<Failure, Success<Void>> handleResponse(HttpResponse response) throws IOException {
                    return HttpClientMediaApiClient.this.translateResponse(response, 200, new ResultMapper<Void>(){

                        @Override
                        public Void apply(HttpResponse response) throws IOException {
                            return null;
                        }
                    });
                }
            });
        }
        catch (IOException exc) {
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.TRANSPORT_ERROR).cause((Throwable)exc).build());
        }
    }

    public Either<Failure, Success<Entity>> copyFile(ClientIdentity identity, String fileId) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(fileId);
        log.debug("Creating a copy of file with Id {}", (Object)fileId);
        HttpPost method = new HttpPost(MediaApiRoute.COPY_FILE.getUrl(new String[]{this.endpoint}));
        try {
            HashMap<String, String> value = new HashMap<String, String>();
            value.put("id", fileId);
            StringEntity content = new StringEntity(this.mapper.writeValueAsString(value));
            content.setContentType("application/json");
            method.setEntity((HttpEntity)content);
        }
        catch (IOException exc) {
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.SERIALIZATION_ERROR).cause((Throwable)exc).build());
        }
        return this.createFile(this.signedRequest((HttpRequestBase)method, identity, UrnHelper.toReadFile((String)fileId), UrnHelper.toCreateFile()));
    }

    public Either<Failure, Success<ClientIdentity>> registerClient(String name, String description) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(description);
        log.debug("Registering a new client of Media API with name: {}", (Object)name);
        HttpPost method = new HttpPost(MediaApiRoute.POST_CLIENT_IDENTITY.getUrl(new String[]{this.endpoint}));
        try {
            StringEntity content = new StringEntity(this.mapper.writeValueAsString((Object)new ClientDetail(name, description)));
            content.setContentType("application/json");
            method.setEntity((HttpEntity)content);
        }
        catch (IOException exc) {
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.SERIALIZATION_ERROR).cause((Throwable)exc).build());
        }
        try {
            return (Either)this.client.execute((HttpUriRequest)method, (ResponseHandler)new ResponseHandler<Either<Failure, Success<ClientIdentity>>>(){

                public Either<Failure, Success<ClientIdentity>> handleResponse(HttpResponse response) throws IOException {
                    return HttpClientMediaApiClient.this.translateResponse(response, 201, new ResultMapper<ClientIdentity>(){

                        @Override
                        public ClientIdentity apply(HttpResponse response) throws IOException {
                            return (ClientIdentity)HttpClientMediaApiClient.this.mapper.readValue(response.getEntity().getContent(), ClientIdentity.class);
                        }
                    });
                }
            });
        }
        catch (IOException exc) {
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.TRANSPORT_ERROR).cause((Throwable)exc).build());
        }
    }

    public Either<Failure, Success<Boolean>> chunkExists(ClientIdentity identity, ChunkETag etag) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(etag);
        log.debug("Checking if chunk with tag {} exists", (Object)etag.toString());
        try {
            return (Either)this.client.execute((HttpUriRequest)this.signedRequest((HttpRequestBase)new HttpHead(MediaApiRoute.CHUNK.getUrl(new String[]{this.endpoint, etag.toString()})), identity, UrnHelper.toReadAnyChunk()), (ResponseHandler)new ResponseHandler<Either<Failure, Success<Boolean>>>(){

                public Either<Failure, Success<Boolean>> handleResponse(HttpResponse response) throws IOException {
                    int status = response.getStatusLine().getStatusCode();
                    switch (status) {
                        case 200: 
                        case 404: {
                            return Either.right((Object)new Success((Object)(status == 200 ? 1 : 0)));
                        }
                    }
                    return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.BAD_STATUS).httpStatusCode(status).message(HttpClientMediaApiClient.this.readResponseBodyQuietly(response)).build());
                }
            });
        }
        catch (IOException e) {
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.TRANSPORT_ERROR).cause((Throwable)e).build());
        }
    }

    public Either<Failure, Success<ChunkETag>> uploadChunk(ClientIdentity identity, byte[] buffer, int length) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(buffer);
        final ChunkETag etag = new ChunkETag(DigestUtils.generateSha1Hash((byte[])buffer, (int)length), length);
        log.debug("Uploading chunk with etag {}", (Object)etag.toString());
        HttpPut uploader = new HttpPut(MediaApiRoute.CHUNK.getUrl(new String[]{this.endpoint, etag.toString()}));
        uploader.setEntity((HttpEntity)new ByteArrayEntity(buffer, 0, length, ContentType.APPLICATION_OCTET_STREAM));
        try {
            return (Either)this.client.execute((HttpUriRequest)this.signedRequest((HttpRequestBase)uploader, identity, UrnHelper.toCreateAnyChunk()), (ResponseHandler)new ResponseHandler<Either<Failure, Success<ChunkETag>>>(){

                public Either<Failure, Success<ChunkETag>> handleResponse(HttpResponse response) throws IOException {
                    int status = response.getStatusLine().getStatusCode();
                    switch (status) {
                        case 200: 
                        case 201: {
                            return Either.right((Object)new Success((Object)etag));
                        }
                    }
                    return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.BAD_STATUS).httpStatusCode(status).message(HttpClientMediaApiClient.this.readResponseBodyQuietly(response)).build());
                }
            });
        }
        catch (IOException e) {
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.TRANSPORT_ERROR).cause((Throwable)e).build());
        }
    }

    public Either<Failure, Success<InputStream>> downloadChunk(ClientIdentity identity, ChunkETag etag) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(etag);
        log.debug("Downloading chunk {}", (Object)etag.toString());
        HttpGet downloader = new HttpGet(MediaApiRoute.CHUNK.getUrl(new String[]{this.endpoint, etag.toString()}));
        try {
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)this.signedRequest((HttpRequestBase)downloader, identity, UrnHelper.toReadAnyChunk()));
            return this.translateResponse((HttpResponse)response, 200, new ResultMapper<InputStream>(){

                @Override
                public InputStream apply(HttpResponse response) throws IOException {
                    return response.getEntity().getContent();
                }
            });
        }
        catch (IOException e) {
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.TRANSPORT_ERROR).cause((Throwable)e).build());
        }
    }

    public Either<Failure, Success<Entity>> createFileFromChunks(ClientIdentity identity, List<ChunkETag> etags, Option<String> fileName) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(etags);
        Objects.requireNonNull(fileName);
        HttpPost fileCreator = new HttpPost(MediaApiRoute.CREATE_FILE_FROM_CHUNKS.getUrl(new String[]{this.endpoint}));
        try {
            StringEntity etagMap = new StringEntity(this.serializeChunksToFileRequest(fileName, etags));
            etagMap.setContentType("application/json");
            fileCreator.setEntity((HttpEntity)etagMap);
        }
        catch (IOException e) {
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.SERIALIZATION_ERROR).cause((Throwable)e).build());
        }
        return this.createFile(this.signedRequest((HttpRequestBase)fileCreator, identity, UrnHelper.toReadAnyChunk(), UrnHelper.toCreateFile()));
    }

    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    String getEndpoint() {
        return this.endpoint;
    }

    private String readResponseBodyQuietly(HttpResponse response) {
        try {
            return EntityUtils.toString((HttpEntity)Objects.requireNonNull(response).getEntity());
        }
        catch (IOException e) {
            return null;
        }
    }

    private <T> Either<Failure, Success<T>> translateResponse(HttpResponse response, int expected, ResultMapper<T> mapper) throws IOException {
        Objects.requireNonNull(response);
        Objects.requireNonNull(mapper);
        if (response.getStatusLine().getStatusCode() == 404) {
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.FILE_NOT_FOUND).httpStatusCode(404).message(this.readResponseBodyQuietly(response)).build());
        }
        if (response.getStatusLine().getStatusCode() != expected) {
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.BAD_STATUS).httpStatusCode(response.getStatusLine().getStatusCode()).message(this.readResponseBodyQuietly(response)).build());
        }
        return Either.right((Object)new Success(mapper.apply(response)));
    }

    private Either<Failure, Success<Entity>> createFile(HttpRequestBase method) {
        Objects.requireNonNull(method);
        try {
            return (Either)this.client.execute((HttpUriRequest)method, (ResponseHandler)new ResponseHandler<Either<Failure, Success<Entity>>>(){

                public Either<Failure, Success<Entity>> handleResponse(HttpResponse httpResponse) throws IOException {
                    return HttpClientMediaApiClient.this.translateResponse(httpResponse, 201, new ResultMapper<Entity>(){

                        @Override
                        public Entity apply(HttpResponse response) throws IOException {
                            return (Entity)HttpClientMediaApiClient.this.mapper.readValue(response.getEntity().getContent(), Entity.class);
                        }
                    });
                }
            });
        }
        catch (IOException exc) {
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.TRANSPORT_ERROR).cause((Throwable)exc).build());
        }
    }

    private Either<Failure, Success<EntityResult>> downloadFile(ClientIdentity identity, String url, String fileId, @Nullable ByteRange range) {
        CloseableHttpResponse resp;
        Objects.requireNonNull(identity);
        Objects.requireNonNull(url);
        HttpRequestBase downloader = this.signedRequest((HttpRequestBase)new HttpGet(url), identity, UrnHelper.toReadFile((String)fileId));
        try {
            resp = this.client.execute((HttpUriRequest)(range == null ? downloader : this.rangeRequest(downloader, range)));
        }
        catch (IOException e) {
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.TRANSPORT_ERROR).cause((Throwable)e).build());
        }
        if (resp.getStatusLine().getStatusCode() != 200 && resp.getStatusLine().getStatusCode() != 206) {
            if (resp.getStatusLine().getStatusCode() == 404) {
                return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.FILE_NOT_FOUND).httpStatusCode(404).message(this.readResponseBodyQuietly((HttpResponse)resp)).build());
            }
            return Either.left((Object)Failure.builder((Failure.Reason)Failure.Reason.BAD_STATUS).httpStatusCode(resp.getStatusLine().getStatusCode()).message(this.readResponseBodyQuietly((HttpResponse)resp)).build());
        }
        final HttpEntity entity = resp.getEntity();
        return Either.right((Object)new Success((Object)new EntityResult((HttpResponse)resp){
            final /* synthetic */ HttpResponse val$resp;
            {
                this.val$resp = httpResponse;
            }

            public long getContentLength() {
                return entity.getContentLength();
            }

            public InputStream getInputStream() throws IOException {
                return entity.getContent();
            }

            public Option<String> getContentRange() {
                Header header = this.val$resp.getFirstHeader("Content-Range");
                return header == null ? Option.none(String.class) : Option.some((Object)header.getValue());
            }

            public String getContentType() {
                Header header = this.val$resp.getFirstHeader("Content-Type");
                Objects.requireNonNull(header, "Media API should always return the Content-Type http header.");
                return header.getValue();
            }
        }));
    }

    @SafeVarargs
    private final HttpRequestBase signedRequest(HttpRequestBase request, ClientIdentity identity, Pair<String, List<String>> ... accessUrns) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(identity);
        request.addHeader("X-Client-Id", identity.getClientId());
        request.addHeader("Authorization", "Bearer " + AuthenticationUtil.generateJWT((String)identity.getClientId(), (String)identity.getSecretKey(), accessUrns));
        return request;
    }

    private HttpRequestBase rangeRequest(HttpRequestBase request, ByteRange range) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(range);
        request.addHeader("Range", "bytes=" + range.getSpecifier());
        return request;
    }

    private String serializeChunksToFileRequest(Option<String> fileName, List<ChunkETag> etags) throws IOException {
        HashMap<String, Object> eTagMap = new HashMap<String, Object>();
        ArrayList<String> eTagList = new ArrayList<String>();
        for (ChunkETag etag : etags) {
            eTagList.add(etag.toString());
        }
        eTagMap.put("chunks", eTagList);
        if (fileName.isDefined()) {
            eTagMap.put("name", fileName.get());
        }
        return this.mapper.writeValueAsString(eTagMap);
    }

    private static interface ResultMapper<T> {
        public T apply(HttpResponse var1) throws IOException;
    }
}

