/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.media.client.util;

import com.atlassian.media.client.api.entity.Artifact;
import com.atlassian.media.client.api.entity.ArtifactType;
import com.atlassian.media.client.api.entity.Entity;
import com.atlassian.media.client.api.entity.ProcessingStatus;
import com.atlassian.media.client.util.JsonDeserializerUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDeserializer
extends JsonDeserializer<Entity> {
    private static final Logger log = LoggerFactory.getLogger(EntityDeserializer.class);

    public Entity deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode root = jsonParser.readValueAsTree();
        JsonNode file = JsonDeserializerUtils.childWithName(root, "data");
        JsonNode artifact = JsonDeserializerUtils.childWithName(file, "artifacts");
        Iterator artifactIterator = artifact.getFields();
        HashMap<ArtifactType, Artifact> artifacts = new HashMap<ArtifactType, Artifact>();
        while (artifactIterator.hasNext()) {
            Map.Entry oneArtifact = (Map.Entry)artifactIterator.next();
            try {
                ArtifactType type = ArtifactType.fromFileName((String)((String)oneArtifact.getKey()));
                if (type == null) continue;
                artifacts.put(type, new Artifact(type, ((JsonNode)oneArtifact.getValue()).get("url").asText(), ProcessingStatus.fromStatusName((String)((JsonNode)oneArtifact.getValue()).get("processingStatus").asText())));
            }
            catch (IllegalArgumentException exc) {
                log.info("Unrecognizable file name", (Throwable)exc);
            }
        }
        return new Entity(file.get("id").getTextValue(), file.get("mimeType").getTextValue(), file.get("mediaType").getTextValue(), file.get("name").getTextValue(), file.get("processingStatus").getTextValue(), file.get("size").getLongValue(), artifacts);
    }
}

