/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.media.client.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestUtils {
    private static final Logger log = LoggerFactory.getLogger(DigestUtils.class);

    public static String generateSha1Hash(byte[] data, int length) {
        MessageDigest digest;
        Objects.requireNonNull(data);
        if (length < 0) {
            throw new IllegalArgumentException("Length should not be negative");
        }
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot get SHA-1 digest provider", e);
        }
        digest.update(data, 0, length);
        return Hex.encodeHexString((byte[])digest.digest());
    }
}

