/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.media.client;

import java.util.Objects;
import javax.annotation.Nonnull;

public class ConnectionDetail {
    private final int connectTimeout;
    private final int socketTimeout;
    private final int connectionTimeToLive;
    private final int maxConnections;
    private final int maxConnectionsPerRoute;
    private final String proxyUrl;

    private ConnectionDetail(int connectTimeout, int socketTimeout, int connectionTimeToLive, int maxConnections, int maxConnectionsPerRoute, String proxyUrl) {
        this.connectTimeout = ConnectionDetail.checkValidTimeout(connectTimeout, "connectTimeout");
        this.socketTimeout = ConnectionDetail.checkValidTimeout(socketTimeout, "socketTimeout");
        this.connectionTimeToLive = ConnectionDetail.checkValidTimeout(connectionTimeToLive, "connectionTimeToLive");
        this.maxConnections = ConnectionDetail.checkPositive(maxConnections, "maxConnections");
        this.maxConnectionsPerRoute = ConnectionDetail.checkPositive(maxConnectionsPerRoute, "maxConnectionsPerRoute");
        this.proxyUrl = proxyUrl;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionTimeToLive() {
        return this.connectionTimeToLive;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    private static int checkPositive(int value, String parameter) {
        if (value <= 0) {
            throw new IllegalArgumentException("Parameter " + parameter + " must be positive, supplied " + value);
        }
        return value;
    }

    private static int checkValidTimeout(int value, String parameter) {
        if (value < -1) {
            throw new IllegalArgumentException("Parameter " + parameter + " must not be less than -1, supplied " + value);
        }
        return value;
    }

    public String toString() {
        return "ConnectionDetail{connectionTimeToLive=" + this.connectionTimeToLive + ", connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + ", maxConnections=" + this.maxConnections + ", maxConnectionsPerRoute=" + this.maxConnectionsPerRoute + ", proxyUrl='" + this.proxyUrl + '\'' + '}';
    }

    public static class Builder {
        private int connectTimeout = -1;
        private int socketTimeout = -1;
        private int connectionTimeToLive = -1;
        private int maxConnections = 20;
        private int maxConnectionsPerRoute = 20;
        private String proxyUrl;

        private Builder() {
        }

        public static Builder defaultBuilder() {
            return new Builder();
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder connectionTimeToLive(int connectionTimeToLive) {
            this.connectionTimeToLive = connectionTimeToLive;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder maxConnectionsPerRoute(int maxConnectionsPerRoute) {
            this.maxConnectionsPerRoute = maxConnectionsPerRoute;
            return this;
        }

        public Builder proxyUrl(@Nonnull String proxyUrl) {
            this.proxyUrl = Objects.requireNonNull(proxyUrl).endsWith("/") ? proxyUrl.replaceAll("/+$", "") : proxyUrl;
            return this;
        }

        public ConnectionDetail build() {
            return new ConnectionDetail(this.connectTimeout, this.socketTimeout, this.connectionTimeToLive, this.maxConnections, this.maxConnectionsPerRoute, this.proxyUrl);
        }
    }
}

