/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.media.client.util;

import com.atlassian.fugue.Pair;
import java.security.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.keys.HmacKey;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationUtil {
    private static final long EXPIRATION_IN_THE_FUTURE_MINS = 10L;
    private static final long NOT_BEFORE_IN_THE_PAST_MINS = 1L;
    private static final Logger log = LoggerFactory.getLogger(AuthenticationUtil.class);

    public static String generateJWT(String clientId, String secretKey) {
        Objects.requireNonNull(clientId);
        Objects.requireNonNull(secretKey);
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(clientId);
        claims.setClaim("unsafe", (Object)true);
        return AuthenticationUtil.sign(secretKey, claims);
    }

    @SafeVarargs
    public static String generateJWT(String clientId, String secretKey, Pair<String, List<String>> ... urns) {
        Objects.requireNonNull(clientId);
        Objects.requireNonNull(secretKey);
        Objects.requireNonNull(urns);
        if (urns.length == 0) {
            throw new IllegalArgumentException("URN must not be empty");
        }
        HashMap<Object, Object> accessUrns = new HashMap<Object, Object>();
        for (Pair<String, List<String>> urn : urns) {
            Objects.requireNonNull(urn);
            log.debug("Adding urn {} -> {}", urn.left(), (Object)((List)urn.right()).toString());
            accessUrns.put(urn.left(), urn.right());
        }
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(clientId);
        claims.setClaim("access", Collections.unmodifiableMap(accessUrns));
        claims.setExpirationTimeMinutesInTheFuture(10.0f);
        claims.setNotBeforeMinutesInThePast(1.0f);
        return AuthenticationUtil.sign(secretKey, claims);
    }

    private static String sign(String secretKey, JwtClaims claim) {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claim.toJson());
        jws.setKey((Key)new HmacKey(secretKey.getBytes()));
        jws.setAlgorithmHeaderValue("HS256");
        try {
            return jws.getCompactSerialization();
        }
        catch (JoseException exc) {
            throw new RuntimeException("Cannot sign a JWT", exc);
        }
    }
}

