/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.media.client.api;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.media.client.api.Failure;
import com.atlassian.media.client.api.Success;
import com.atlassian.media.client.api.entity.ArtifactType;
import com.atlassian.media.client.api.entity.ByteRange;
import com.atlassian.media.client.api.entity.ChunkETag;
import com.atlassian.media.client.api.entity.ClientIdentity;
import com.atlassian.media.client.api.entity.Entity;
import com.atlassian.media.client.api.entity.EntityResult;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

@PublicApi
public interface MediaApiClient
extends Closeable {
    public Either<Failure, Success<Entity>> getFile(ClientIdentity var1, String var2);

    public Either<Failure, Success<Entity>> uploadFile(ClientIdentity var1, @WillNotClose InputStream var2, @Nullable String var3);

    public Either<Failure, Success<EntityResult>> downloadOriginalFile(ClientIdentity var1, String var2);

    public Either<Failure, Success<EntityResult>> downloadOriginalFile(ClientIdentity var1, String var2, @Nullable ByteRange var3);

    public Either<Failure, Success<EntityResult>> downloadArtifact(ClientIdentity var1, String var2, ArtifactType var3);

    public Either<Failure, Success<EntityResult>> downloadArtifact(ClientIdentity var1, String var2, ArtifactType var3, @Nullable ByteRange var4);

    public Either<Failure, Success<Void>> deleteFile(ClientIdentity var1, String var2);

    public Either<Failure, Success<Entity>> copyFile(ClientIdentity var1, String var2);

    public Either<Failure, Success<ClientIdentity>> registerClient(String var1, String var2);

    public Either<Failure, Success<Boolean>> chunkExists(ClientIdentity var1, ChunkETag var2);

    public Either<Failure, Success<ChunkETag>> uploadChunk(ClientIdentity var1, byte[] var2, int var3);

    public Either<Failure, Success<InputStream>> downloadChunk(ClientIdentity var1, ChunkETag var2);

    public Either<Failure, Success<Entity>> createFileFromChunks(ClientIdentity var1, List<ChunkETag> var2, Option<String> var3);
}

