/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.cenqua.clover.tasks.HistoryPointTask;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.Project;

public class CloverSaveHistoryMojo
extends AbstractCloverMojo {
    private String historyDir;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping clover save-history.");
            return;
        }
        if (this.areCloverDatabasesAvailable()) {
            super.execute();
            AbstractCloverMojo.waitForFlush(this.getWaitForFlush(), this.getFlushInterval());
            this.save();
        } else {
            this.getLog().info((CharSequence)"No Clover database found, skipping the Clover history point save");
        }
    }

    private void save() {
        if (new File(this.getCloverDatabase()).exists()) {
            this.saveDatabase(this.getCloverDatabase());
        }
        if (new File(this.getCloverMergeDatabase()).exists()) {
            this.saveDatabase(this.getCloverMergeDatabase());
        }
    }

    private void saveDatabase(String database) {
        Project antProject = new Project();
        antProject.init();
        AbstractCloverMojo.registerCloverAntTasks(antProject, this.getLog());
        this.getLog().info((CharSequence)("Saving Clover history point for database [" + database + "] in [" + this.historyDir + "]"));
        HistoryPointTask cloverHistoryTask = (HistoryPointTask)antProject.createTask("clover-historypoint");
        cloverHistoryTask.init();
        cloverHistoryTask.setInitString(database);
        cloverHistoryTask.setHistoryDir(new File(this.historyDir));
        cloverHistoryTask.execute();
    }
}

